import { CONFIG } from '../config';
import { emailEnum } from '../enum/email.enum';

export class EmailService {
  static sendVerificationEmail(user: any, userId: string): void {
    Accounts.emailTemplates.siteName = CONFIG.SiteName;
    // Will uncomment it later with domain email
    // Accounts.emailTemplates.from = CONFIG.DomainEmail;

    Accounts.emailTemplates.verifyEmail = {
      subject() {
        return emailEnum.REGISTER_HEADING(CONFIG.SiteName);
      },
      html(usr, url) {
        const token = url.substr(url.lastIndexOf('/') + 1);
        const link = `${process.env.appUrl}#/auth/verify-email/${token}`;
        return emailEnum.REGISTER_EMAIL_BODY(user.name, user.role, link);
      },
    };

    Accounts.sendVerificationEmail(userId, user.email);
  }

  static sendForgotPasswordEmail(user: Meteor.User, email: string): void {
    Accounts.emailTemplates.siteName = CONFIG.SiteName;
    // Will uncomment it later with domain email
    // Accounts.emailTemplates.from = CONFIG.DomainEmail;

    Accounts.emailTemplates.resetPassword = {
      subject() {
        return emailEnum.RESET_HEADING(CONFIG.SiteName);
      },
      html(usr, url) {
        const token = url.substr(url.lastIndexOf('/') + 1);
        const link = `${process.env.appUrl}#/auth/reset-password/${token}`;
        return emailEnum.RESET_EMAIL_BODY(user.profile.name, link);
      },
    };

    Accounts.sendResetPasswordEmail(user._id, email);
  }
}
