import { Meteor } from 'meteor/meteor';
import { first } from 'rxjs/operators';
import { Roles } from '../collections/role.collection';
import { PERMISSIONS } from '../config';
import { RoleModel } from '../models/role.model';
import { UtilsService } from '../services/utils.service';

Meteor.methods({
  async saveRole(role: RoleModel): Promise<void> {
    try {
      if (role._id && UtilsService.hasPermission(PERMISSIONS.UPDATE_ROLE)) {
        await Roles.update(role._id, role)
          .pipe(first())
          .toPromise();
      }
    } catch (e) {
      throw new Meteor.Error('Unable to add.', JSON.stringify(e));
    }
  },
});
