import { Meteor } from 'meteor/meteor';

import { Roles } from './collections/role.collection';
import { PERMISSIONS } from './config';

export const seedDB = async () => {

  // tslint:disable-next-line:ban-ts-ignore
  // @ts-ignore
  const allPermissions = Object.values(PERMISSIONS);

  try {
    if (!Roles.find({})
      .fetch().length || Roles.find({})
      .fetch().length === 0) {
      // Roles
      await Promise.all([
        Roles.insert({
          title: 'Admin',
          permissions: allPermissions,
          description: '',
        }).toPromise(),
        Roles.insert({
          title: 'User',
          permissions: [PERMISSIONS.CAN_LOGIN, PERMISSIONS.CAN_UPDATE_OWN_USER],
          description: '',
        }).toPromise(),
        Roles.insert({
          title: 'Blocked',
          permissions: [],
          description: '',
        }),
      ]);
    } else {
      // Update Roles Permissions
      await Promise.all([
        Roles
          .update({ title: 'Admin' }, { $set: { permissions: allPermissions } })
          .toPromise(),
      ]);
    }

    if (!Meteor.users.find({})
      .fetch().length && Meteor.users.find({})
      .fetch().length === 0) {

      Accounts.createUser({
        username: 'admin',
        password: 'admin',
        email: 'ali.arshad@vqode.com',
        profile: {
          name: 'Admin User',
          role: Roles.findOne({ title: 'Admin' })._id, // admin role id
        },
      });
    }
  } catch (e) {
    throw new Meteor.Error('Error while seeding database.');
  }
};
