// tslint:disable-next-line:no-require-imports import-name
import AWS = require('aws-sdk');
import { Meteor } from 'meteor/meteor';
import { Observable, Subject } from 'rxjs';
import { Roles } from '../collections/role';
import { User } from '../models/user';

export class UtilsService {

  static getLoggedInUserPermissions(): string[] {
    const usr: User = Meteor.user();
    const role = Roles.findOne(usr.profile.Role);

    return role.Permissions;
  }

  static hasPermission(permissions: string | string[]): boolean {
    const usr: User = Meteor.user();
    if (usr) {
      const role = Roles.findOne(usr.profile.Role);

      if (typeof permissions === 'string') {
        return role.Permissions.indexOf(permissions) !== -1;
      }

      return permissions.every(p => role.Permissions.indexOf(p) !== -1);
    }

    return false;
  }

  static hasPermissionOfUser(user: User, permission: string): boolean {
    const role = Roles.findOne(user.profile.Role);

    return role.Permissions.indexOf(permission) !== -1;
  }

  static uploadToAWS(base64, key): Observable<any> {

    AWS.config.update({
      accessKeyId: 'AKIAIKEPLM32K6ZXO2WQ',
      secretAccessKey: '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',
      signatureVersion: 'v4',
    });

    const s3 = new AWS.S3();
    const subject = new Subject();
    const base64Data = new Buffer(base64.replace(/^data:image\/\w+;base64,/, ''), 'base64');

    // With this setup, each time your users uploads an image, will be overwritten.
    // To prevent this, use a unique Key each time.
    // This won't be needed if they're uploading their avatar, hence the filename, userAvatar.js.
    const params = {
      Bucket: 'vqode-tracker',
      Key: key, // type is not required
      Body: base64Data,
      ACL: 'public-read',
      ContentEncoding: 'base64', // required
      ContentLength: Buffer.byteLength(base64Data),
      ContentType: 'image/jpeg', // required. Notice the back ticks
    };
    // The upload() is used instead of putObject() as we'd need the location url and
    // assign that to our users profile/database
    // see: http://docs.aws.amazon.com/AWSJavaScriptSDK/latest/AWS/S3.html#upload-property

    s3.upload(params, Meteor.bindEnvironment((err, data): any => {
      if (err) {
        subject.error(err);
        subject.complete();

        // tslint:disable-next-line:no-console
        return console.log(err);
      }
      subject.next(data);
      subject.complete();
      // Continue if no error
      // Save data.Location in your database
    }));

    return subject.asObservable();
  }
}
