import { Meteor } from 'meteor/meteor';
// tslint:disable-next-line:ban-ts-ignore
// @ts-ignore
import { publishComposite } from 'meteor/reywood:publish-composite';
import { PERMISSIONS } from '../config';
import { Query } from '../models/query';
import { UtilsService } from '../services/utils.service';
import { Roles } from '../collections/role';

publishComposite('usersList', (filters = {}) => {

  const queryFilters = { ...new Query(), ...filters };

  if (!UtilsService.hasPermission([PERMISSIONS.CAN_SEE_ALL_USERS])) {
    throw new Meteor.Error(403, 'Not enough permissions to get all users');
  }

  return {
    find(): any {
      return Meteor.users.find(queryFilters.query, { ...queryFilters.options });
    },
    children: [
      {
        find(user): any {
          return Roles.find({ _id: user.profile.Role });
        },
      },
    ],
  };
});
