import { Meteor } from 'meteor/meteor';
import { Roles } from '../collections/role';
import { PERMISSIONS } from '../config';
import { User } from '../models/user';
import { UtilsService } from '../services/utils.service';
import { Query } from '../models/query';

Meteor.methods({

  usersGetCount(query: Query): any {
    return {
      recordsFiltered: Meteor.users.find(query.query).count(),
      recordsTotal: Meteor.users.find().count(),
    };

  },

  registerUser(user: any): string {
    const myRole = Roles.findOne({ Title: user.role });
    if (!Accounts.findUserByEmail(user.email)) {

      const userObj = {
        email: user.email,
        password: user.password,
        username: user.username,
        profile: {
          Name: user.name,
          Email: user.email,
          Password: user.password,
          Role: myRole._id,
          Status: user.status,
          RoleObj: myRole,
        },
      };
      return Accounts.createUser(userObj);
    }
    throw new Meteor.Error(422, 'Email address already in use.');
  },

  updateUser(user: User): any {
    if (!UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_OWN_USER)) {
      throw new Meteor.Error(403, 'Forbidden.');
    }
    if (user._id) {
      const updateObj = { $set: { profile: user.profile } };
      if (user.profile.Email) {
        updateObj.$set['emails.0.address'] = user.profile.Email;
      }

      return Meteor.users.update(user._id, updateObj);
    }
  },
  disableUser(user: User): any {
    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_USER)) {
      const disableRole = Roles.findOne({ Title: 'Blocked' });
      const usr = Meteor.users.findOne(user._id);
      usr.profile.Role = disableRole._id;

      return Meteor.users.update(user._id, usr);
    }
    throw new Meteor.Error(403, 'Not enough permissions');
  },

  checkUserByEmail(email: string): User {
    return Accounts.findUserByEmail(email);
  },

  async enableUser(user: User): Promise<any> {
    if (UtilsService.hasPermission(PERMISSIONS.CAN_UPDATE_USER)) {
      // const role = Roles.findOne({ Slug: user.profile.OriginalRole });
      const usr = Meteor.users.findOne(user._id);
      // usr.profile.Role = role._id;

      return Meteor.users.update(user._id, usr);
    }
    throw new Meteor.Error(403, 'Not enough permissions');
  },

});
