import { Meteor } from 'meteor/meteor';
import { first } from 'rxjs/operators';
import { Roles } from '../collections/role';
import { PERMISSIONS } from '../config';
import { Role } from '../models/role';
import { UtilsService } from '../services/utils.service';

Meteor.methods({
  async saveRole(role: Role): Promise<void> {
    try {
      if (role._id && UtilsService.hasPermission(PERMISSIONS.UPDATE_ROLE)) {
        await Roles.update(role._id, role)
          .pipe(first())
          .toPromise();
      }
    } catch (e) {
      throw new Meteor.Error('Unable to add.', JSON.stringify(e));
    }
  },
});
