import { Meteor } from 'meteor/meteor';
import { seedDB } from './app.seeding';
import { PERMISSIONS } from './config';
import { User } from './models/user';
import { UtilsService } from './services/utils.service';

Meteor.startup(() => {
  const seed = true;

  if (seed) {
    seedDB();
  }

  // Validate Login Attempt
  Accounts.validateLoginAttempt((data): boolean => {
    const user: User = data.user;

    return user && user.profile.Role
      && UtilsService.hasPermissionOfUser(user, PERMISSIONS.CAN_LOGIN);
  });

  // Changing url of reset password
  Accounts.emailTemplates.resetPassword.text = (user, url) => {
    const token = url.substring(url.lastIndexOf('/') + 1, url.length);

    return Meteor.absoluteUrl(`auth/reset-password/${token}`);
  };
});
