import { Meteor } from 'meteor/meteor';

import { Roles } from './collections/role';
import { PERMISSIONS } from './config';

export const seedDB = async () => {

  // tslint:disable-next-line:ban-ts-ignore
  // @ts-ignore
  const allPermissions = Object.values(PERMISSIONS);

  try {
    if (!Roles.find({})
      .fetch().length || Roles.find({})
      .fetch().length === 0) {
      // Roles
      await Promise.all([
        Roles.insert({
          Title: 'Admin',
          Permissions: allPermissions,
          Description: '',
        }).toPromise(),
        Roles.insert({
          Title: 'User',
          Permissions: [PERMISSIONS.CAN_LOGIN, PERMISSIONS.CAN_UPDATE_OWN_USER],
          Description: '',
        }).toPromise(),
      ]);
    } else {
      // Update Roles Permissions
      await Promise.all([
        Roles
          .update({ Title: 'Admin' }, { $set: { Permissions: allPermissions } })
          .toPromise(),
      ]);
    }

    if (!Meteor.users.find({})
      .fetch().length && Meteor.users.find({})
      .fetch().length === 0) {

      Accounts.createUser({
        username: 'admin',
        password: 'admin',
        email: 'ali.arshad@vqode.com',
        profile: {
          Role: Roles.findOne({ Title: 'Admin' })._id, // admin role id
          FirstName: 'Admin',
          LastName: 'User',
          Status: 'ACTIVE',
        },
      });
    }
  } catch (e) {
    throw new Meteor.Error('Error while seeding database.');
  }
};
