import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';
import { AlreadyLoginGuard } from './already-login.guard';
import { AppGuard } from './app.guard';
import { PendingChangesGuard } from './pending.changes.guard';
import { RoleGuard } from './role.guard';

declare global {
  interface NodeModule {
    dynamicImport(path: string): any;
  }
}

export const routes: Routes = [];

@NgModule({
  imports: [RouterModule.forRoot(routes, {preloadingStrategy: PreloadAllModules})],
  exports: [RouterModule],
  declarations: [],
  providers: [AppGuard, PendingChangesGuard, AlreadyLoginGuard, RoleGuard]
})
export class RoutesModule {
}
