import { Injectable } from '@angular/core';
import { ActivatedRouteSnapshot, CanActivate, Router, RouterStateSnapshot } from '@angular/router';

@Injectable()
export class AppGuard implements CanActivate {
  constructor(private readonly router: Router) {
    // nothing in constructor
  }

  canActivate(next: ActivatedRouteSnapshot,
              state: RouterStateSnapshot): boolean {
    if (Meteor.user()) {
      return true;
    }
    this.router.navigate(['/auth/login']);

  }
}
