import { Injectable } from '@angular/core';
import { ActivatedRouteSnapshot, CanActivate, Router, RouterStateSnapshot } from '@angular/router';

@Injectable()
export class RoleGuard implements CanActivate {
  constructor(private readonly router: Router) {
    // nothing in constructor
  }

  canActivate(next: ActivatedRouteSnapshot,
              state: RouterStateSnapshot): boolean {
    if (Meteor.user()) {
      const roles = next.data.roles;
      if (roles.indexOf(Meteor.user().profile.role) > -1) {

        return true;
      }
      this.router.navigate(['/auth/login']);
    } else {
      this.router.navigate(['/auth/login']);
    }
  }
}
