import { Injectable } from '@angular/core';
import { ActivatedRouteSnapshot, CanActivate, Router, RouterStateSnapshot } from '@angular/router';

@Injectable()
export class AlreadyLoginGuard implements CanActivate {
  constructor(private readonly router: Router) {
  }

  canActivate(next: ActivatedRouteSnapshot,
              state: RouterStateSnapshot): boolean {
    if (Meteor.user()) {
      this.router.navigate(['/']);

      return false;
    }

    return true;
  }
}
