const express = require('express');
const request = require('request');
const fs = require('fs');
const Q = require('q');
const app = express();
const util = require('util');
const exec = util.promisify(require('child_process').exec);
const bodyParser = require('body-parser')

const port = process.env.port || 3000;
const jsonParser = bodyParser.json();


app.post('/', jsonParser, async (req, res) => {
    const result = {
        status: 'failed'
    };

    try {
        let path = __dirname;
        let url = req.body.url;

        if (url) {
            if (url.indexOf('http') == -1) {
                url = 'http://' + url;
            }
            path += '/data/' + url.split('://')[1];
            const data = await execSiteSpeed(url, path);
            result.status = 'success';
            result.data = data;
        } else {
            result.messgae = "URL not provided.";
        }
    } catch (e) {
        console.log(e);
    }
    res.send(result);
});
app.use(express.static('data'));

app.listen(port, () => console.log(`Example app listening on port ${port}!`));

async function execSiteSpeed(url, path) {
    await exec(`docker run --rm -v "$(pwd)/data":/browsertime/browsertime-results/ sitespeedio/browsertime:7.8.2 --video --screenshot --visualMetrics -n 1 ${url}`)
    return readFromFile(path);
}

function readFromFile(path) {
    const dirData = fs.readdirSync(path);
    const latest = dirData.pop();
    return new Promise((res, rej) => {
        fs.readFile(`${path}/${latest}/browsertime.json`, function (err, buf) {
            if (err) {
                rej(new Error(err.toString()));
            }
            if (buf) {
                res({
                    dir: latest,
                    data: JSON.parse(buf.toString())[0]
                });
            }
        });

        dirData.forEach(d => {
            if (new Date().getTime() - new Date(fs.statSync(`${path}/${d}`).ctime).getTime() > 300000) {
                exec(`rm -rf ${path}/${d}`);
            }

        })
    });
}
