<?php



function vq_theme_settings_page()
{
    ?>
    <div class="wrap">
        <h1>Theme Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields("section");
            do_settings_sections("hosting-review-theme-options");
            submit_button();
            ?>
        </form>
    </div>
    <?php
}

add_action('admin_menu', 'vq_add_theme_setting_page');

function display_hosting_companies_table()
{
    ?>
    <input style="display: none;" type="text" name="vq_hosting_companies" id="vq_hosting_companies" value="" />
    <style>
        .hosting-companies {
            border-collapse: collapse;
            text-align: center;
        }
        .hosting-companies th, .hosting-companies td {
            padding: 5px;
            text-align: center;
        }

        .hosting-companies tbody tr:nth-child(even) {
            background: #fff;
        }
        .hosting-companies tbody tr:nth-child(odd) {
            background: #ddd;
        }

        .hosting-companies tr.in-edit  {
            background: #b4b9be !important;
        }

        #cancel-company-btn {
            display: none;
        }
    </style>

    <table>
        <tr>
            <td>Title: <input type="text" id="new-company-title"></td>
            <td>Slug: <input type="text" id="new-company-slug"></td>
            <td><button onclick="saveCompany()" type="button" id="add-company-btn">Add</button></td>
            <td><button onclick="resetData()" type="button" id="cancel-company-btn">Cancel</button></td>
        </tr>
        <tr>

        </tr>
    </table>


    <table class="hosting-companies">
        <thead>
        <tr>
            <th>Title</th>
            <th>Slug</th>
            <th></th>
        </tr>
        </thead>
        <tbody id="hosting-companies-body">
        </tbody>
    </table>
    <script>
        var hostingCompaniesData = <?php echo get_option('vq_hosting_companies'); ?>;
        if (!hostingCompaniesData) {
            hostingCompaniesData = [];
        }
        var inEditIndex = -1;
        var titleEl = document.getElementById('new-company-title');
        var slugEl = document.getElementById('new-company-slug');
        var cancelEl = document.getElementById('cancel-company-btn');

        function saveCompany() {
            if (!titleEl.value || !slugEl.value) {
                return alert('Please fill all fields');
            }
            if (inEditIndex > -1) {
                hostingCompaniesData[inEditIndex].title = titleEl.value;
                hostingCompaniesData[inEditIndex].slug = slugEl.value;
            } else {
                hostingCompaniesData.push({title: titleEl.value, slug: slugEl.value});
            }
            populateTable();
            resetData();
        }

        function editCompany(index) {
            resetData();
            inEditIndex = index;
            titleEl.value = hostingCompaniesData[index].title;
            slugEl.value = hostingCompaniesData[index].slug;
            document.getElementById('add-company-btn').innerText = 'Update';
            document.getElementById(`hosting-company-${index}`).classList.add('in-edit');
            document.getElementById('cancel-company-btn').style.display = 'block';
        }

        function deleteCompany(index) {
            if (confirm('Are you you want to remove this company?')) {
                hostingCompaniesData.splice(index, 1);
                populateTable();
                resetData();
            }
        }

        function resetData() {
            if (inEditIndex > -1) {
                document.getElementById(`hosting-company-${inEditIndex}`).classList.remove('in-edit');
            }
            titleEl.value = '';
            slugEl.value = '';
            inEditIndex = -1;
            document.getElementById('cancel-company-btn').style.display = 'none';
        }

        function populateTable() {
            var tableBody = document.getElementById('hosting-companies-body');
            tableBody.innerHTML = '';
            hostingCompaniesData.forEach(function(company, index) {
                var row = `<tr id="hosting-company-${index}">`;
                row += `<td>${company.title}</td>`;
                row += `<td>${company.slug}</td>`;
                row += `<td><a style="cursor:pointer;" onclick="editCompany(${index})">Edit</a> &nbsp;&nbsp; <a style="cursor:pointer;" onclick="deleteCompany(${index})"> Delete</a></td>`;
                row += `</tr>`;
                tableBody.innerHTML += row;
            });
            resetData();
            document.getElementById('vq_hosting_companies').value = JSON.stringify(hostingCompaniesData);
        }

        populateTable();
    </script>
    <?php
}


function vq_display_theme_panel_fields()
{
    add_settings_section("section", "Hosting Companies", null, "hosting-review-theme-options");

    add_settings_field("vq_hosting_companies", "Add Hosting Company", "display_hosting_companies_table", "hosting-review-theme-options", "section");

    register_setting("section", "vq_hosting_companies");
}


add_action("admin_init", "vq_display_theme_panel_fields");
