<?php
/*
Template Name: Blog Page
*/
?>

<?php get_header(); ?>

<div class="container">
    <div class="row">
        <div class="col-sm-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo site_url();  ?>"><?php echo get_the_title( get_option('page_on_front') ) ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo REVIEWS_PAGE ?></li>
                </ol>
            </nav>
        </div>
        <div class="col-sm-8">

            <div class="row">

                <?php
                    $loop = new WP_Query( array( 'post_type' => 'hosting_reviews', 'paged' => true, 'posts_per_page' => 5 ) );
                    if ( $loop->have_posts() ) :
                        while ( $loop->have_posts() ) : $loop->the_post(); ?>

                            <div class="col-sm-12">
                                <img class="blogImage" src="<?php echo get_the_post_thumbnail_url();?>">
                                <div class="blogSingle">
                                    <h3><?php the_title(); ?> </h3>
                                </div>
                                <div class="d-flex spaceBetween">
                                    <div class="singleBox r-margin">
                                        <img class="userIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/user-icon.png">
                                        <div class="blogSingle d-inline-block">
                                            <h5><?php echo get_the_author_meta('display_name'); ?> </h5>
                                        </div>
                                    </div>
                                    <div class="singleBox">
                                        <img class="userIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/date-icon.png">
                                        <div class="blogSingle d-inline-block">
                                            <h5><?php  the_time('F j, Y'); ?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <?php endwhile;
                        if (  $loop->max_num_pages > 1 ) : ?>
                            <div id="nav-below" class="navigation">
                                <div class="nav-previous"><?php next_posts_link( __( '<span class="meta-nav">&larr;</span> Previous', 'domain' ) ); ?></div>
                                <div class="nav-next"><?php previous_posts_link( __( 'Next <span class="meta-nav">&rarr;</span>', 'domain' ) ); ?></div>
                            </div>
                        <?php endif;
                    endif;
                    wp_reset_postdata();
                ?>

            </div>

            <div class="d-flex j-content-center">
                <nav aria-label="Page navigation example">
                    <ul class="pagination">
                        <li class="page-item">
                            <a class="page-link" href="#" aria-label="Previous">
                                <span aria-hidden="true">«</span>
                            </a>
                        </li>
                        <li class="page-item"><a class="page-link" href="#">01</a></li>
                        <li class="page-item"><a class="page-link" href="#">02</a></li>
                        <li class="page-item"><a class="page-link" href="#">03</a></li>
                        <li class="page-item"><a class="page-link" href="#">04</a></li>
                        <li class="page-item"><a class="page-link" href="#">05</a></li>
                        <li class="page-item">
                            <a class="page-link" href="#" aria-label="Next">
                                <span aria-hidden="true">»</span>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>

        <div class="col-md-4">

            <?php get_sidebar(); ?>

        </div>
    </div>
</div>


<?php
get_footer();




//<?php
//    $loop = new WP_Query( array( 'post_type' => 'hosting_reviews', 'paged' => true ) );
//    if ( $loop->have_posts() ) :
//        while ( $loop->have_posts() ) : $loop->the_post(); ?>
<!--            <div class="pindex">-->
<!--                --><?php //if ( has_post_thumbnail() ) { ?>
<!--                    <div class="pimage">-->
<!--                        <a href="--><?php //the_permalink(); ?><!--">--><?php //the_post_thumbnail(); ?><!--</a>-->
<!--                    </div>-->
<!--                --><?php //} ?>
<!--            </div>-->
<!--        --><?php //endwhile;
//        if (  $loop->max_num_pages > 1 ) : ?>
<!--            <div id="nav-below" class="navigation">-->
<!--                <div class="nav-previous">--><?php //next_posts_link( __( '<span class="meta-nav">&larr;</span> Previous', 'domain' ) ); ?><!--</div>-->
<!--                <div class="nav-next">--><?php //previous_posts_link( __( 'Next <span class="meta-nav">&rarr;</span>', 'domain' ) ); ?><!--</div>-->
<!--            </div>-->
<!--        --><?php //endif;
//    endif;
//    wp_reset_postdata();
//?>
