<div class="subscribeBackground">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <div class="subscribeTitle">
                    <h3>SUBSCRIBE TO MY NEWSLETTER</h3>
                    <h2>Stay up to date with my blogging news</h2>
                </div>
            </div>
            <div class="col-md-12" id="footerFormContainer">
                <div class="row">
                    <div class="col-sm-4">
                        <input type="name" class="form-control SubscribeInput" id="subscriberName" placeholder="Name">
                    </div>
                    <div class="col-sm-4">
                        <input type="email" class="form-control SubscribeInput" id="subscriberEmail" placeholder="Email">
                    </div>
                    <div class="col-sm-4">
                        <button class="btn orange updateButton" type="submit" onclick="subscribeUser()">Stay Update!</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script>

    jQuery(document).ready(function ($) {
        var subscriberNameEl = document.getElementById('subscriberName');
        var subscriberEmailEl = document.getElementById('subscriberEmail');

        subscribeUser = function(){
            if (subscriberNameEl.value.trim() && validateEmail(subscriberEmailEl.value)) {
                var actData = {
                    'action': 'add_review_subscribers',
                    'email': subscriberEmailEl.value,
                    'name': subscriberNameEl.value
                };

                $.post(ajax_url, actData, function(response) {
                    if (response === 0) {
                        return alert('Could not subscribe');
                    }

                    document.getElementById('footerFormContainer').innerHTML = '<h4>You have successfully subscribed. We will get in touch.</h4>';
                });
            } else {
                alert('Please enter a valid name & email.');
            }
        };

        validateEmail = function(mail) {
            return /^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(mail)
        };
    });
</script>

<!-- Footer Section Code Start-->
<!-------------------->
<div class="footer light">
    <div class="container">
        <div class="row">
            <div class="col-sm-4">
                <div class="footerTitle">
                    <h2><?php echo get_theme_mod( "vq-about-us-title-text"); ?></h2>
                </div>
                <?php the_custom_logo(); ?>
                <div class="footerTitle">
                    <p> <?php echo get_theme_mod( "vq-about-company-text"); ?> </p>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="footerTitle">
                    <h2><?php echo wp_get_nav_menu_name('primary') ?></h2>
                </div>
                <ul class="nav flex-column">
                    <?php
                    $menuLocations = get_nav_menu_locations();

                    $menuID = $menuLocations['primary'];

                    $nav = wp_get_nav_menu_items($menuID);
                    foreach ($nav as $items) { ?>
                    <li class="nav-item">
                        <a class="nav-link active" href="<?php echo $items->url; ?>"><?php echo $items->title; ?></a>
                    </li>
                    <?php } ?>
                </ul>
            </div>
            <div class="col-sm-4">
                <div class="footerTitle">
                    <h2><?php echo wp_get_nav_menu_name('secondary') ?></h2>
                </div>
                <ul class="nav flex-column">
                    <?php
                    $menuLocations = get_nav_menu_locations();

                    $menuID = $menuLocations['secondary'];

                    $nav = wp_get_nav_menu_items($menuID);
                    foreach ($nav as $items) { ?>
                        <li class="nav-item">
                            <a class="nav-link active" href="<?php echo $items->url; ?>"><?php echo $items->title; ?></a>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="copyright">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <div class="copyrightTitle">
                    <?php echo get_theme_mod( "vq-copyright-text"); ?>
                </div>
            </div>
        </div>
    </div>
</div>
<!-------------------->
<!-- Footer Section Code End-->
<?php wp_footer(); ?>
</body>
<!-------------------->
<!-- Body Code End-->






<!-- Bootstrap Script Start-->
<!-------------------->
<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
<!-------------------->
<!-- Bootstrap Script End-->
</html>
