<?php
/*
Template Name: Blog Page
*/
?>

<?php get_header(); ?>

<div class="container">
    <div class="row">
        <div class="col-sm-12">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo site_url();  ?>"><?php echo get_the_title( get_option('page_on_front') ) ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo BLOG_PAGE ?></li>
                </ol>
            </nav>
        </div>
        <div class="col-sm-8">
            <div class="row">

                <?php

                $the_query = new WP_Query(array(
                    'posts_per_page' => 10
                ));

                if ( $the_query->have_posts() ) :

                    while ( $the_query->have_posts() ) : $the_query->the_post();
                ?>

                        <div class="col-lg-6">
                            <img class="blogImage" src="<?php echo get_the_post_thumbnail_url();  ?>">
                            <a href="<?php the_permalink(); ?>"><h3><?php echo get_the_title() ?></h3></a>
                            <div class="d-flex spaceBetween">
                                <div>
                                    <img class="blogUser" style="width: 30px; height: 30px; border-radius: 50%" src="<?php echo get_avatar_url( get_the_author_meta('user_email'), '60' ); ?>">
                                    <h5><?php echo get_the_author_meta('display_name') ?></h5>
                                </div>
                                <div>
                                    <h5 class="pt-1 responsive"><?php  the_time('F j, Y'); ?></h5>
                                </div>
                            </div>
                        </div>

                    <?php

                    endwhile;

                    ?>

                <?php
                endif;

                ?>

            </div>

            <div class="d-flex j-content-center">
                <nav aria-label="Page navigation example">
                    <ul class="pagination">
                        <li class="page-item">
                            <a class="page-link" href="#" aria-label="Previous">
                                <span aria-hidden="true">«</span>
                            </a>
                        </li>
                        <li class="page-item"><a class="page-link" href="#">01</a></li>
                        <li class="page-item"><a class="page-link" href="#">02</a></li>
                        <li class="page-item"><a class="page-link" href="#">03</a></li>
                        <li class="page-item"><a class="page-link" href="#">04</a></li>
                        <li class="page-item"><a class="page-link" href="#">05</a></li>
                        <li class="page-item">
                            <a class="page-link" href="#" aria-label="Next">
                                <span aria-hidden="true">»</span>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>

        <div class="col-md-4">

            <?php get_sidebar(); ?>

        </div>
    </div>
</div>


<?php
get_footer();
