<?php

function vq_theme_settings_page()
{
    ?>
    <div class="wrap">
        <h1>Theme Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields("section");
            do_settings_sections("hosting-review-theme-options");

            do_settings_sections("hosting-server-locations");

            submit_button();
            ?>
        </form>
    </div>
    <?php
}

add_action('admin_menu', 'vq_add_theme_setting_page');

function display_hosting_companies_table()
{
    ?>


    <table class="hosting-companies-listing mb-3">
        <thead>
        <tr>
            <th>Title</th>
            <th>Organization</th>
            <th>Hosting</th>
            <th>Locations</th>
            <th></th>
        </tr>
        </thead>
        <tbody id="hosting-companies-body">

        </tbody>
    </table>

    <div class="hosting-company-data" id="hosting-data-wrapper">
        <div class="row align-items-center">
            <div class ="col-md-3"><label>Name</label></div>
            <div class="col-md-9"><input type="text" id="hosting-company-name"></div>
        </div>
        <div class="row mt-2 align-items-center">
            <div class ="col-md-3"><label>Organization</label></div>
            <div class="col-md-9"><input type="text" id="hosting-company-slug"></div>
        </div>
        <div>
            <h4 class="mb-2">Hosting Packages</h4>
            <div id="hosting-packages-wrapper">

            </div>
        </div>
        <a style="cursor: pointer;" onclick="addHostingPackages()">+ Add Package</a>


        <div class="mt-3">
            <h4 class="mb-2">Server Locations</h4>
            <div id="hosting-locations-wrapper">

            </div>
        </div>
        <a style="cursor: pointer;" onclick="addHostingLocation()">+ Add Location</a>

        <div class="d-flex justify-content-between mt-4">
            <button type="button" class="button button-primary" onclick="saveHostingCompany()">Save</button>
            <button type="button" class="button" onclick="resetChanges()">Cancel</button>
        </div>
    </div>


    <input style="display: none;" type="text" name="vq_hosting_companies_details" id="vq_hosting_companies_details" value="" />

    <script>
        var hostingCompaniesDetails = <?php echo get_option('vq_hosting_companies_details') ? get_option('vq_hosting_companies_details') : '[]'; ?>;
    </script>
    <?php
}

function display_server_locations()
{
    ?>
    <table class="server-locations-listing mb-3">
        <thead>
        <tr>
            <th>Locations</th>
            <th>Domain</th>
            <th></th>
        </tr>
        </thead>
        <tbody id="server-locations-body">

        </tbody>
    </table>


    <div class="server-location-data" id="server-location-data-wrapper">
        <div class="row">
            <div class="col-md-6">
                <label for="">Location</label>
                <input type="text" id="server-location-field">
            </div>
            <div class="col-md-6">
                <label for="">Domain</label>
                <input type="text" id="server-domain-field">
            </div>
        </div>

        <div class="d-flex justify-content-between mt-4">
            <button type="button" class="button button-primary" onclick="saveServerLocation()">Save</button>
            <button type="button" class="button" onclick="resetServerLocationsChanges()">Cancel</button>
        </div>
    </div>


    <input style="display: none;" type="text" name="vq_hosting_server_locations" id="vq-hosting-server-locations" value="" />

    <script>
        var serverLocationsDetails = <?php echo get_option('vq_hosting_server_locations') ? get_option('vq_hosting_server_locations') : '[]'; ?>;
    </script>
    <?php
}


function vq_display_theme_panel_fields()
{
    add_settings_section("section", "Configuration Details", null, "hosting-review-theme-options");

    add_settings_field("vq_hosting_companies", "Hosting Companies", "display_hosting_companies_table", "hosting-review-theme-options", "section");
    register_setting("section", "vq_hosting_companies_details");

	add_settings_field("vq_hosting_locations", "Server Locations", "display_server_locations", "hosting-review-theme-options", "section");
	register_setting("section", "vq_hosting_server_locations");

}


add_action("admin_init", "vq_display_theme_panel_fields");
