<?php
/*
Template Name: Blog Page
*/
?>

<?php get_header(); ?>

    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo site_url(); ?>"><?php echo get_the_title( get_option( 'page_on_front' ) ) ?></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo REVIEWS_PAGE ?></li>
                    </ol>
                </nav>
            </div>
            <div class="col-sm-8">

                <div class="row">

					<?php
					$page = isset($_GET['page']) ? $_GET['page'] : 1;

					$loop  = new WP_Query( array( 'post_type'      => 'hosting_reviews',
					                              'paged'          => $page,
					                              'posts_per_page' => 10
					) );

					if ( $loop->have_posts() ) :
						while ( $loop->have_posts() ) : $loop->the_post(); ?>

                            <div class="col-sm-12">
                                <img class="blogImage" src="<?php echo get_the_post_thumbnail_url(); ?>">
                                <div class="blogSingle">
                                    <a href="<?php the_permalink(); ?>"><h3><?php the_title(); ?> </h3></a>
                                </div>
                                <div class="d-flex spaceBetween">
                                    <div class="singleBox r-margin">
                                        <img class="userIcon"
                                             src="<?php echo get_template_directory_uri(); ?>/assets/images/user-icon.png">
                                        <div class="blogSingle d-inline-block">
                                            <h5><?php echo get_the_author_meta( 'display_name' ); ?> </h5>
                                        </div>
                                    </div>
                                    <div class="singleBox">
                                        <img class="userIcon"
                                             src="<?php echo get_template_directory_uri(); ?>/assets/images/date-icon.png">
                                        <div class="blogSingle d-inline-block">
                                            <h5><?php the_time( 'F j, Y' ); ?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>

						<?php endwhile;
					endif;
					?>
                    <div class="pagination d-flex justify-content-center w-100">
                        <?php
                        $page = isset($_GET['page']) ? $_GET['page'] : 1;
                        echo paginate_links( array(
	                        'current' => $page,
	                        'format' => '?page=%#%',
	                        'prev_text' => '«',
	                        'next_text' => '»',
	                        'total'   => $loop->max_num_pages
                        ) );
                        ?>
                    </div>
                </div>
            </div>

            <div class="col-md-4">

				<?php get_sidebar(); ?>

            </div>
        </div>
    </div>


<?php
get_footer();
