<?php
/*
Template Name: Summary Page
*/

get_header();

$domain = '';
if ( isset( $_GET['domain'] ) ) {
	$domain = $_GET['domain'];
}

?>

<!-- Summary Section Code Start-->
<!-------------------->
<div class="container">
    <div class="row">
        <div class="col-sm-12">
            <div class="summaryHeading">
                <h3 class="orangeColor">Summary</h3>
            </div>
        </div>
        <div class="col-md-12 d-flex justify-content-center mt-5">
            <div class="loader" id="result-loader"></div>
        </div>
        <div class="row m-0" id="reviewData">
            <div class="col-sm-4">
                <img class="summaryHostImage"  id="screenshotImg" src="<?php echo get_template_directory_uri(); ?>/assets/images/host-image.jpg">
                <video controls class="summaryHostImage" src="" id="loadVideo"></video>
            </div>
            <div class="col-md-8 mt17">
                <div class="row">
                    <div class="col-sm-4 mb-2">
                        <div class="summaryBox w-100">
                            <img class="boxTopLeftOther pTop-0 left-15"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png"
                                 alt="">
                            <div class="d-flex j-content-center">
                                <img class="mr-2"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
                                <div class="summaryHeading">
                                    <h5>Domain</h5>
                                </div>
                                <img class="ml-2"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
                            </div>
                            <div class="summaryHeading">
                                <h4 class="orangeColor" id="domainName"></h4>
                            </div>
                            <img class="boxTopRight rightResponsive"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png"
                                 alt="">
                        </div>
                    </div>
                    <div class="col-sm-4 mb-2">
                        <div class="summaryBox w-100">
                            <img class="boxTopLeftOther pTop-0 left-15"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png"
                                 alt="">
                            <div class="d-flex j-content-center">
                                <img class="mr-2"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
                                <div class="summaryHeading">
                                    <h5>Hosting</h5>
                                </div>
                                <img class="ml-2"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
                            </div>
                            <div class="summaryHeading">
                                <h4 class="orangeColor" id="hostingName"></h4>
                            </div>
                            <img class="boxTopRight rightResponsive"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png"
                                 alt="">
                        </div>
                    </div>
                    <div class="col-sm-4 mb-2">
                        <div class="summaryBox w-100">
                            <img class="boxTopLeftOther pTop-0 left-15"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png"
                                 alt="">
                            <div class="d-flex j-content-center">
                                <img class="mr-2"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
                                <div class="summaryHeading">
                                    <h5>IP</h5>
                                </div>
                                <img class="ml-2"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
                            </div>
                            <div class="summaryHeading">
                                <h4 class="orangeColor" id="domainIP"></h4>
                            </div>
                            <img class="boxTopRight rightResponsive"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png"
                                 alt="">
                        </div>
                    </div>
                </div>
                <div class="d-none d-sm-block d-md-block">
                    <img class="summarySocailIocn"
                         src="<?php echo get_template_directory_uri(); ?>/assets/images/facebook-icon.jpg" alt="">
                    <img class="summarySocailIocn top-133"
                         src="<?php echo get_template_directory_uri(); ?>/assets/images/twitter-icon.jpg" alt="">
                    <img class="summarySocailIocn top-177"
                         src="<?php echo get_template_directory_uri(); ?>/assets/images/linked-icon.jpg" alt="">
                </div>
                <table class="table table-striped radius">
                    <thead class="orange summaryTable">
                    <tr>
                        <th scope="col" class="tableBorder">Locations</th>
                        <th scope="col" class="tableBorder">Server Response Time</th>
                        <th scope="col" class="tableBorder">Page Load Time</th>
                    </tr>
                    </thead>
                    <tbody class="tableBody" id="reviewTableDetailsBody">
                    <!--                     -->
                    </tbody>
                </table>
                <div class="row m-0">
                    <div class="col-sm-3 pl-0 summaryPadding">
                        <img class="boxTopLeftOther top-20 top-7 left-0 "
                             src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
                        <div class="summaryAfterBox">
                            <div class="responseHeading">
                                <h5>Average Response Time</h5>
                                <h4><strong id="avgResTime"></strong> <span>ms</span></h4>
                            </div>
                        </div>
                        <img class="boxTopRight right-5"
                             src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
                    </div>
                    <div class="col-sm-3 summaryPadding">
                        <div class="summaryAfterBox">
                            <img class="boxTopLeftOther top-20 top-7 left-5"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png"
                                 alt="">
                            <div class="responseHeading">
                                <h5>Average Page Load Time</h5>
                                <h4><strong id="avgPageLoadTime"></strong> <span>ms</span></h4>
                            </div>
                            <img class="boxTopRight right-5"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png"
                                 alt="">
                        </div>
                    </div>
                    <div class="col-sm-3 summaryPadding">
                        <div class="summaryAfterBox">
                            <img class="boxTopLeftOther top-20 top-7 left-5"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png"
                                 alt="">
                            <div class="responseHeading">
                                <h5>Grade</h5>
                                <h4 id="reviewGrade"></h4>
                            </div>
                            <img class="boxTopRight right-5"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png"
                                 alt="">
                        </div>
                    </div>
                    <div class="col-sm-3 pr-0 summaryPadding">
                        <div class="summaryAfterBox">
                            <img class="boxTopLeftOther top-20 top-7 left-5"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png"
                                 alt="">
                            <div class="responseHeading">
                                <h5>Performance</h5>
                                <h4><strong id="reviewPerformance"></strong> <span>%</span></h4>

                            </div>
                            <img class="boxTopRight right-0"
                                 src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png"
                                 alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12" id="hasProblems">
            <div class="row">
                <div class="col-sm-12">
                    <div class="summaryHeading">
                        <h3 class="orangeColor transform">Problems Detected with your website</h3>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="detectedHeading">
                        <h4>Your server response time is very high. Consider changing your web host.</h4>
                    </div>
                </div>
                <div class="col-sm-4">
                    <button type="button" class="hostsButton dark btn btn-primary">Recommended Web Hosts</button>
                </div>
                <div class="col-sm-8">
                    <div class="detectedHeading">
                        <h4>You are not using any cache plugins. Cache plugins are a must to speed up your website load
                            time.</h4>
                    </div>
                </div>
                <div class="col-sm-4">
                    <button type="button" class="hostsButton dark btn btn-primary">Recommended Cache Plugins</button>
                </div>
            </div>
        </div>

    </div>
</div>
<!-------------------->
<!-- Summary Section Code End-->

<!-- Website Optimize Section Code Start-->
<!-------------------->
<img class="mt-5 optimizeWidth" src="<?php echo get_template_directory_uri(); ?>/assets/images/optimize-top.png" alt="">
<div class="optimizeBackground dark w-100">
    <div class="container">
        <div class="row">
            <div class="col-sm-5">
                <img class="w-100 d-none d-sm-block d-md-block"
                     src="<?php echo get_template_directory_uri(); ?>/assets/images/optimize-ipad.png" alt="">
            </div>
            <div class="col-sm-7">
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/optimize-star.png" alt="">
                <div class="optimizeHeading">
                    <h2>Want your website optimize</h2>
                </div>
                <button type="button" class="btn btn-primary optimizeHireButton">Hire us now</button>
            </div>
        </div>
    </div>
</div>
<div class="d-flex f-end">
    <img class="optimizeWidth" src="<?php echo get_template_directory_uri(); ?>/assets/images/optimize-bottom.png"
         alt="">
</div>
<!-- Website Optimize Section Code End-->
<!-------------------->

<!-- Server Response Section Code Start-->
<!-------------------->
<div class="container" id="top-hostings">
	<?php
	$page = get_page_by_title( TOP_HOSTING );
	echo $page->post_content;
	?>
</div>
<!-- Server Response Section Code End-->
<!-------------------->

<!-- Cache Section Code Start-->
<!-------------------->
<div class="container" id="top-cache-plugins">
	<?php
	$page = get_page_by_title( TOP_CACHE_PLUGINS );
	echo $page->post_content;
	?>
</div>
<!-- Cache Section Code End-->
<!-------------------->

<script>
    var domain_addr = '<?php echo $domain ?>';


    jQuery(document).ready(function ($) {

        var reviewData = document.getElementById('reviewData');
        var resultLoader = document.getElementById('result-loader');
        var topHostings = document.getElementById('top-hostings');
        var topCachePlugins = document.getElementById('top-cache-plugins');
        var hasProblems = document.getElementById('hasProblems');
        var reviewTableDetailsBody = document.getElementById('reviewTableDetailsBody');

        var avgResTimeEl = document.getElementById('avgResTime');
        var avgPageLoadTimeEl = document.getElementById('avgPageLoadTime');
        var reviewGradeEl = document.getElementById('reviewGrade');
        var reviewPerformanceEl = document.getElementById('reviewPerformance');
        var domainNameEl = document.getElementById('domainName');
        var hostingNameEl = document.getElementById('hostingName');
        var domainIPEl = document.getElementById('domainIP');
        var screenshotImgEl = document.getElementById('screenshotImg');
        var loadVideoEl = document.getElementById('loadVideo');

        topHostings.style.display = 'none';
        topCachePlugins.style.display = 'none';
        hasProblems.style.display = 'none';

        if (domain_addr) {
            var actData = {
                'action': 'get_speed_results',
                'domain': domain_addr
            };


            resultLoader.style.display = 'block';
            reviewData.style.display = 'none';


            $.post(ajax_url, actData, function(response) {
                if (response.error) {
                    return alert(response.error);
                }

                reviewTableDetailsBody.innerHTML = '';
                reviewData.style.display = 'flex';
                resultLoader.style.display = 'none';
                const results = JSON.parse(response);

                var respTime = 0;
                var loadTime = 0;
                results.forEach(res => {
                    var reviewRowTemplate = `<tr>
                        <td class="summaryTD">${res.server_location}</td>
                        <td class="summaryTD">${res.server_response_time} ms</td>
                        <td class="summaryTD">${res.page_load_time} ms</td>
                    </tr>`;
                    reviewTableDetailsBody.innerHTML += reviewRowTemplate;
                    respTime += +res.server_response_time;
                    loadTime += +res.page_load_time;
                });

                domainNameEl.innerText = results[0].domain_addr;
                domainIPEl.innerText = results[0].domain_ip;
                hostingNameEl.innerText = results[0].hosting_name;
                hostingNameEl.innerText = '-';
                reviewGradeEl.innerText = 'A';
                reviewPerformanceEl.innerText = 'X';
                avgResTimeEl.innerText = Math.floor(respTime / results.length).toString();
                avgPageLoadTimeEl.innerText = Math.floor(loadTime / results.length).toString();
                screenshotImgEl.src = results[0].imgPath;
                loadVideoEl.src = results[0].videoPath;

             });
        }
    });

</script>

<?php get_footer(); ?>

