<div id="sidebar-primary" class="sidebar">
    <div class="sideBarBox">
        <div class="sideBar">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/sidebar-hosting-icon.png">
            <h2><?php echo get_theme_mod( "vq-speed-test-heading") ?></h2>
        </div>
        <div class="col-sm-12">
            <form class="form-inline">
                <input class="form-control sidebarInput" type="search" placeholder="Enter URL" aria-label="Search">
                <button class="btn btn-outline-success testButton dark" type="submit">Test</button>
            </form>
        </div>
    </div>
    <div class="sideBarBox">
        <div class="recentTitleBox">
            <div class="d-flex spaceBetween">
                <h4><?php echo get_theme_mod( "vq-recent-posts-heading") ?></h4>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/recent-icon.png">
            </div>
        </div>
        <div class="d-flex j-content-center">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/bottom-style.png">
        </div>
        <?php
        $recent_posts = wp_get_recent_posts(array(
            'numberposts' => 2, // Number of recent posts thumbnails to display
            'post_status' => 'publish' // Show only the published posts
        ));

        foreach ($recent_posts as $post) { ?>
            <div class="col-sm-12">
                <div class="postBox">
                    <img src="<?php echo get_the_post_thumbnail_url($post['ID']); ?>">
                    <div class="postHeading">
                        <h3><?php echo $post['post_title']; ?></h3>
                        <div class="post-content">
                            <?php echo $post['post_content']; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>

    <div class="sideBarBox">

        <div class="recentTitleBox">
            <div class="d-flex spaceBetween">
                <h4><?php echo get_theme_mod( "vq-top-reviews-heading") ?></h4>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/recent-icon.png">
            </div>
        </div>
        <div class="d-flex j-content-center">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/bottom-style.png">
        </div>

        <?php
        $recent_reviews = wp_get_recent_posts(array(
                'numberposts'   => 2,
                'orderby'       => 'post_date',
                'order'         => 'DESC',
                'post_type'     => 'hosting_reviews',
                'post_status'   => 'publish'
            ));


        foreach ($recent_reviews as $recent_review) { ?>

            <div class="col-sm-12">
                <div class="postBox">
                    <img class="w-100 postImage" src="<?php echo get_the_post_thumbnail_url($post['ID']); ?>" alt="">
                    <div class="postHeading">
                        <h3><?php echo $recent_review['post_title'] ?> </h3>
                        <div class="post-content">
                            <?php echo $recent_review['post_content'] ?>
                        </div>
                    </div>
                </div>
            </div>

        <?php } ?>

    </div>
    <div class="sideBarBox pb-0">
        <div class="recentTitleBox">
            <div class="d-flex spaceBetween">
                <h4><?php echo get_theme_mod( "vq-top-hosting-heading") ?></h4>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-icon.png">
            </div>
        </div>
        <div class="d-flex j-content-center">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/bottom-style.png">
        </div>
        <div class="col-sm-12">
            <div class="d-flex spaceBetween">
                <img class="hostingLogo" src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.png">
                <button class="btn btn-outline-success reviewButton" type="submit"><i class="fas fa-eye"></i> Review</button>
            </div>
        </div>
        <div class="borderBottom"></div>
        <div class="col-sm-12">
            <div class="d-flex spaceBetween">
                <img class="hostingLogo" src="images/hosting-logo.png">
                <button class="btn btn-outline-success reviewButton" type="submit"><i class="fas fa-eye"></i> Review</button>
            </div>
        </div>
        <div class="borderBottom"></div>
        <div class="col-sm-12">
            <div class="d-flex spaceBetween">
                <img class="hostingLogo" src="images/hosting-logo.png">
                <button class="btn btn-outline-success reviewButton" type="submit"><i class="fas fa-eye"></i> Review</button>
            </div>
        </div>
        <div class="borderBottom"></div>
        <div class="col-sm-12">
            <div class="d-flex spaceBetween">
                <img class="hostingLogo" src="images/hosting-logo.png">
                <button class="btn btn-outline-success reviewButton" type="submit"><i class="fas fa-eye"></i> Review</button>
            </div>
        </div>
        <div class="borderBottom"></div>
        <div class="col-sm-12">
            <div class="d-flex spaceBetween">
                <img class="hostingLogo" src="images/hosting-logo.png">
                <button class="btn btn-outline-success reviewButton" type="submit"><i class="fas fa-eye"></i> Review</button>
            </div>
        </div>
        <div class="borderBottom"></div>
        <div class="col-sm-12">
            <div class="d-flex spaceBetween">
                <img class="hostingLogo" src="images/hosting-logo.png">
                <button class="btn btn-outline-success reviewButton" type="submit"><i class="fas fa-eye"></i> Review</button>
            </div>
        </div>
    </div>
    <div class="sideBarBox">
        <div class="sideBar newsletterPadding">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/newsletter-icon.png">
            <h2><?php echo get_theme_mod( "vq-newsletter-heading") ?></h2>
        </div>
        <div class="col-sm-12">
            <form class="form-inline">
                <input class="form-control sidebarInput w65" type="search" placeholder="Newsletter" aria-label="Search">
                <button class="btn btn-outline-success testButton orange " type="submit">Submit</button>
            </form>
        </div>
    </div>

</div>
