<?php


// Insert Default pages
define('BANNER_PAGE', 'Home Banner');
define('HOSTING_REVIEW_PAGE', 'Web Hosting Review');
define('ABOUT_US_PAGE', 'About Us');
define('RECENT_REVIEWS_PAGE', 'Recent Reviews');
define('REVIEWS_PAGE', 'Reviews');
define('TOP_BLOG_PAGE', 'Top Blog Posts');
define('NEWSLETTER_PAGE', 'Newsletter Page');
define('TOP_HOSTING', 'Top Hosting Lists');
define('TOP_CACHE_PLUGINS', 'Recommended Cache Plugins');
define('BLOG_PAGE', 'Blog');

$defaultPagesBanner = [BANNER_PAGE, HOSTING_REVIEW_PAGE, ABOUT_US_PAGE, RECENT_REVIEWS_PAGE, TOP_BLOG_PAGE, NEWSLETTER_PAGE, BLOG_PAGE, TOP_HOSTING, TOP_CACHE_PLUGINS];
for ($i = 0; $i < count($defaultPagesBanner); $i++) {
	$new_page_title = $defaultPagesBanner[$i];
	$page_check = get_page_by_title($new_page_title);
	$new_page = array(
		'post_type' => 'page',
		'post_title' => $new_page_title,
		'post_content' => '',
		'post_status' => 'publish',
		'post_author' => 1,
	);
	if(!isset($page_check->ID)){
		$new_page_id = wp_insert_post($new_page);
	}
}

function vq_set_default_data()
{
	global $wpdb;
	$table_name = $wpdb->prefix . "speed_results";

	$sql = "CREATE TABLE $table_name (";
    $sql .=  "id int(10) unsigned NOT NULL AUTO_INCREMENT,";
	$sql .=  "server_location varchar(255) DEFAULT NULL,";
	$sql .=  "batch_id varchar(255) DEFAULT NULL,";
	$sql .=  "server_name varchar(255) DEFAULT NULL,";
	$sql .=  "hosting_name varchar(255) DEFAULT NULL,";
	$sql .=  "domain_addr varchar(255) DEFAULT NULL,";
	$sql .=  "domain_ip varchar(255) DEFAULT NULL,";
	$sql .=  "timestamp varchar(255) DEFAULT NULL,";
	$sql .=  "video varchar(255) DEFAULT NULL,";
	$sql .=  "screen_shot varchar(255) DEFAULT NULL,";
	$sql .=  "server_response_time varchar(255) DEFAULT NULL,";
	$sql .=  "page_load_time varchar(255) DEFAULT NULL,";
	$sql .=  "PRIMARY KEY  (id)";
	$sql .=  ") ENGINE=InnoDB DEFAULT CHARSET=utf8;";

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
}

add_action("after_switch_theme", "vq_set_default_data");
