<?php


function vq_enqueue_theme_resources()
{
    $templateUri = get_template_directory_uri();
    $assetsFolder = "$templateUri/assets";
    wp_enqueue_style('vq_customStyle', "$assetsFolder/css/custom.css", array(), '1.0.0', 'all');

}

function vq_register_theme_supports()
{
    add_theme_support('menus');
    add_theme_support('custom-background');
    add_theme_support('post-thumbnails');
    add_theme_support('custom-logo');

    register_nav_menu('primary', 'Primary Menu');
    register_nav_menu('secondary', 'Secondary Menu');
}


// Register Settings sin the Customizer API
function vq_theme_customize_register( $wp_customize ) {
    $wp_customize->add_section('vq_footer_section', array(
        'title' => __('Footer Settings'),
        'priority' => 30
    ));

    $wp_customize->add_setting('vq-copyright-text', array());
    $wp_customize->add_setting('vq-about-company-text', array());
    $wp_customize->add_setting('vq-about-us-title-text', array());


    $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            'vq_about_us_title_text',
            array(
                'label' => __('About Us Title'),
                'section' => 'vq_footer_section',
                'settings' => 'vq-about-us-title-text',
                'priority' => 1
            )
        )
    );


    $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            'vq_about_company_text',
            array(
                'type' => 'textarea',
                'label' => __('About'),
                'section' => 'vq_footer_section',
                'settings' => 'vq-about-company-text',
                'priority' => 2
            )
        )
    );

    $wp_customize->add_control(new WP_Customize_Control(
            $wp_customize,
            'vq_copyright_text',
            array(
                'type' => 'textarea',
                'label' => __('Copyright'),
                'section' => 'vq_footer_section',
                'settings' => 'vq-copyright-text',
                'priority' => 3
            )
        )
    );

    // ..repeat ->add_setting() and ->add_control() for mytheme_company-division
}
add_action( 'customize_register', 'vq_theme_customize_register' );


//
//function subscribe_hosting_shortcode() {
//    ob_start();
//    get_template_part('hosting');
//    return ob_get_clean();
//}
//add_shortcode('subscribe-to-hosting', 'subscribe_hosting_shortcode');
//
//add_action('init', 'do_output_buffer');
//function do_output_buffer() {
//    ob_start();
//}
//
//

//
//
//$paged = ($_GET['paged'])? $_GET['paged'] : 1;
//$args = array('post_type' => 'post', 'post_status' => 'publish', 'posts_per_page' => 14, 'paged' => $paged);
//query_posts($args);
//
//function my_post_queries( $query ) {
//    // do not alter the query on wp-admin pages and only alter it if it's the main query
//    if (!is_admin() && $query->is_main_query()){
//
//        // alter the query for the home and category pages
//
//        if(is_home()){
//            $query->set('posts_per_page', 14);
//        }
//
//        if(is_category()){
//            $query->set('posts_per_page', 3);
//        }
//
//    }
//}
//add_action( 'pre_get_posts', 'my_post_queries' );


// Include Admin
$templateDirectory = get_template_directory();
require_once("$templateDirectory/admin/functions.php");

// Actions
add_action('wp_enqueue_scripts', 'vq_enqueue_theme_resources');
add_action('init', 'vq_register_theme_supports');
add_action('init', 'vq_add_theme_default_pages');
