<?php
/*
Template Name: Summary Page
*/
?>

<?php get_header();?>

<!-- Summary Section Code Start-->
<!-------------------->
<div class="container">
	<div class="row">
		<div class="col-sm-12">
			<div class="summaryHeading">
				<h3 class="orangeColor">Summary</h3>
			</div>
		</div>
		<div class="row m-0">
			<div class="col-sm-4">
				<img class="summaryHostImage" src="<?php echo get_template_directory_uri(); ?>/assets/images/host-image.jpg">
				<div class="hostHeading">
					<h5>HostGator</h5>
				</div>
				<img class="summaryHostImage" src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-video.jpg">
			</div>
			<div class="col-md-8 mt17">
				<div class="row">
					<div class="col-sm-4 mb-2">
						<div class="summaryBox w-100">
							<img class="boxTopLeftOther pTop-0 left-15" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
							<div class="d-flex j-content-center">
								<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
								<div class="summaryHeading">
									<h5>Domain</h5>
								</div>
								<img class="ml-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
							</div>
							<div class="summaryHeading">
								<h4 class="orangeColor">hostgator.com</h4>
							</div>
							<img class="boxTopRight rightResponsive" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
						</div>
					</div>
					<div class="col-sm-4 mb-2">
						<div class="summaryBox w-100">
							<img class="boxTopLeftOther pTop-0 left-15" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
							<div class="d-flex j-content-center">
								<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
								<div class="summaryHeading">
									<h5>Hosting</h5>
								</div>
								<img class="ml-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
							</div>
							<div class="summaryHeading">
								<h4 class="orangeColor">Amazone Cloud</h4>
							</div>
							<img class="boxTopRight rightResponsive" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
						</div>
					</div>
					<div class="col-sm-4 mb-2">
						<div class="summaryBox w-100">
							<img class="boxTopLeftOther pTop-0 left-15" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
							<div class="d-flex j-content-center">
								<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
								<div class="summaryHeading">
									<h5>IP</h5>
								</div>
								<img class="ml-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/summary-star.png">
							</div>
							<div class="summaryHeading">
								<h4 class="orangeColor">588.25.14.15</h4>
							</div>
							<img class="boxTopRight rightResponsive" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
						</div>
					</div>
				</div>
				<div class="d-none d-sm-block d-md-block">
					<img class="summarySocailIocn" src="<?php echo get_template_directory_uri(); ?>/assets/images/facebook-icon.jpg" alt="">
					<img class="summarySocailIocn top-133" src="<?php echo get_template_directory_uri(); ?>/assets/images/twitter-icon.jpg" alt="">
					<img class="summarySocailIocn top-177" src="<?php echo get_template_directory_uri(); ?>/assets/images/linked-icon.jpg" alt="">
				</div>
				<table class="table table-striped radius">
					<thead class="orange summaryTable">
					<tr>
						<th scope="col" class="tableBorder">Locations</th>
						<th scope="col" class="tableBorder">Server Response Time</th>
						<th scope="col" class="tableBorder">Page Load Time</th>
					</tr>
					</thead>
					<tbody class="tableBody">
					<tr>
						<td class="summaryTD">US (W)</td>
						<td class="summaryTD">2.009 ms</td>
						<td class="summaryTD">2.009 ms</td>
					</tr>
					<tr>
						<td class="summaryTD">USE</td>
						<td class="summaryTD">2.009 ms</td>
						<td class="summaryTD">2.009 ms</td>
					</tr>
					<tr>
						<td class="summaryTD">London</td>
						<td class="summaryTD">2.009 ms</td>
						<td class="summaryTD">2.009 ms</td>
					</tr>
					<tr>
						<td class="summaryTD">Singapore</td>
						<td class="summaryTD">2.009 ms</td>
						<td class="summaryTD">2.009 ms</td>
					</tr>
					</tbody>
				</table>
				<div class="row m-0">
					<div class="col-sm-3 pl-0 summaryPadding">
						<img class="boxTopLeftOther top-20 top-7 left-0 " src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
						<div class="summaryAfterBox">
							<div class="responseHeading">
								<h5>Average Response Time</h5>
								<h4>2.009 <span>ms</span></h4>
							</div>
						</div>
						<img class="boxTopRight right-5" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
					</div>
					<div class="col-sm-3 summaryPadding">
						<div class="summaryAfterBox">
							<img class="boxTopLeftOther top-20 top-7 left-5" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
							<div class="responseHeading">
								<h5>Average Page Load Time</h5>
								<h4>2.009 <span>ms</span></h4>
							</div>
							<img class="boxTopRight right-5" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
						</div>
					</div>
					<div class="col-sm-3 summaryPadding">
						<div class="summaryAfterBox">
							<img class="boxTopLeftOther top-20 top-7 left-5" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
							<div class="responseHeading">
								<h5>Grade</h5>
								<h4>A<br></h4>
							</div>
							<img class="boxTopRight right-5" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
						</div>
					</div>
					<div class="col-sm-3 pr-0 summaryPadding">
						<div class="summaryAfterBox">
							<img class="boxTopLeftOther top-20 top-7 left-5" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
							<div class="responseHeading">
								<h5>Performance</h5>
								<h4>X <span>%</span></h4>

							</div>
							<img class="boxTopRight right-0" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="col-sm-12">
			<div class="summaryHeading">
				<h3 class="orangeColor transform">Problems Detected with your website</h3>
			</div>
		</div>
		<div class="col-sm-8">
			<div class="detectedHeading">
				<h4>Your server response time is very high. Consider changing your web host.</h4>
			</div>
		</div>
		<div class="col-sm-4">
			<button type="button" class="hostsButton dark btn btn-primary">Recommended Web Hosts</button>
		</div>
		<div class="col-sm-8">
			<div class="detectedHeading">
				<h4>You are not using any cache plugins. Cache plugins are a must to speed up your website load time.</h4>
			</div>
		</div>
		<div class="col-sm-4">
			<button type="button" class="hostsButton dark btn btn-primary">Recommended Cache Plugins</button>
		</div>
	</div>
</div>
<!-------------------->
<!-- Summary Section Code End-->

<!-- Website Optimize Section Code Start-->
<!-------------------->
<img class="mt-5 optimizeWidth" src="<?php echo get_template_directory_uri(); ?>/assets/images/optimize-top.png" alt="">
<div class="optimizeBackground dark w-100">
	<div class="container">
		<div class="row">
			<div class="col-sm-5">
				<img class="w-100 d-none d-sm-block d-md-block" src="<?php echo get_template_directory_uri(); ?>/assets/images/optimize-ipad.png" alt="">
			</div>
			<div class="col-sm-7">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/optimize-star.png" alt="">
				<div class="optimizeHeading">
					<h2>Want your website optimize</h2>
				</div>
				<button type="button" class="btn btn-primary optimizeHireButton">Hire us now</button>
			</div>
		</div>
	</div>
</div>
<div class="d-flex f-end">
	<img class="optimizeWidth" src="<?php echo get_template_directory_uri(); ?>/assets/images/optimize-bottom.png" alt="">
</div>
<!-- Website Optimize Section Code End-->
<!-------------------->

<!-- Server Response Section Code Start-->
<!-------------------->
<div class="container">
	<div class="row">
		<div class="col-sm-12">
			<div class="d-flex j-content-center">
				<img class="mt-3" src="<?php echo get_template_directory_uri(); ?>/assets/images/server-star.png" alt="">
			</div>
			<div class="serverTime">
				<h2>Your server response time is slow</h2>
				<h4>Please consider one of the following hostings</h4>
			</div>
		</div>
		<div class="col-sm-12">
			<div class="table-responsive mt-4 tableShadow">
				<table class="table table-striped">
					<thead>
					<tr>
						<th class="borderTop0 textAlignCenter" scope="col">#</th>
						<th class="borderTop0" scope="col">Hosting Provider</th>
						<th class="borderTop0" scope="col">Top Features</th>
						<th class="borderTop0" scope="col">Live Uptime</th>
						<th class="borderTop0" scope="col">Average Ping</th>
						<th class="borderTop0" scope="col">Overall Rating</th>
						<th class="borderTop0 borderRight0" scope="col">Link</th>
					</tr>
					</thead>
					<tbody>
					<tr>
						<th scope="row" class="textAlignCenter">1</th>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.jpg"></td>
						<td><i class="fa fa-check greenColor mr-1"></i> Best of Wordpress</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/uptime-icon.png"> 100.00%</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/average-icon.png"> 92ms</td>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/table-star.png" alt=""></td>
						<td><button class="btn btn-outline-success reviewButton pt-0" type="submit"><i class="fa fa-eye mr-1"></i> Review</button></td>
					</tr>
					<tr>
						<th scope="row" class="textAlignCenter">2</th>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.jpg"></td>
						<td><i class="fa fa-check greenColor mr-1"></i> Best of Wordpress</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/uptime-icon.png"> 100.00%</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/average-icon.png"> 92ms</td>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/table-star.png" alt=""></td>
						<td><button class="btn btn-outline-success reviewButton pt-0" type="submit"><i class="fa fa-eye mr-1"></i> Review</button></td>
					</tr>
					<tr>
						<th scope="row" class="textAlignCenter">3</th>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.jpg"></td>
						<td><i class="fa fa-check greenColor mr-1"></i> Best of Wordpress</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/uptime-icon.png"> 100.00%</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/average-icon.png"> 92ms</td>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/table-star.png" alt=""></td>
						<td><button class="btn btn-outline-success reviewButton pt-0" type="submit"><i class="fa fa-eye mr-1"></i> Review</button></td>
					</tr>
					<tr>
						<th scope="row" class="textAlignCenter">4</th>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.jpg"></td>
						<td><i class="fa fa-check greenColor mr-1"></i> Best of Wordpress</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/uptime-icon.png"> 100.00%</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/average-icon.png"> 92ms</td>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/table-star.png" alt=""></td>
						<td><button class="btn btn-outline-success reviewButton pt-0" type="submit"><i class="fa fa-eye mr-1"></i> Review</button></td>
					</tr>
					<tr>
						<th scope="row" class="textAlignCenter">5</th>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.jpg"></td>
						<td><i class="fa fa-check greenColor mr-1"></i> Best of Wordpress</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/uptime-icon.png"> 100.00%</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/average-icon.png"> 92ms</td>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/table-star.png" alt=""></td>
						<td><button class="btn btn-outline-success reviewButton pt-0" type="submit"><i class="fa fa-eye mr-1"></i> Review</button></td>
					</tr>
					<tr>
						<th scope="row" class="textAlignCenter">6</th>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.jpg"></td>
						<td><i class="fa fa-check greenColor mr-1"></i> Best of Wordpress</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/uptime-icon.png"> 100.00%</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/average-icon.png"> 92ms</td>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/table-star.png" alt=""></td>
						<td><button class="btn btn-outline-success reviewButton pt-0" type="submit"><i class="fa fa-eye mr-1"></i> Review</button></td>
					</tr>
					<tr>
						<th scope="row" class="textAlignCenter">7</th>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.jpg"></td>
						<td><i class="fa fa-check greenColor mr-1"></i> Best of Wordpress</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/uptime-icon.png"> 100.00%</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/average-icon.png"> 92ms</td>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/table-star.png" alt=""></td>
						<td><button class="btn btn-outline-success reviewButton pt-0" type="submit"><i class="fa fa-eye mr-1"></i> Review</button></td>
					</tr>
					<tr>
						<th scope="row" class="textAlignCenter">8</th>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/hosting-logo.jpg"></td>
						<td><i class="fa fa-check greenColor mr-1"></i> Best of Wordpress</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/uptime-icon.png"> 100.00%</td>
						<td><img class="upTimeIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/average-icon.png"> 92ms</td>
						<td><img src="<?php echo get_template_directory_uri(); ?>/assets/images/table-star.png" alt=""></td>
						<td><button class="btn btn-outline-success reviewButton pt-0" type="submit"><i class="fa fa-eye mr-1"></i> Review</button></td>
					</tr>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>
<!-- Server Response Section Code End-->
<!-------------------->

<!-- Cache Section Code Start-->
<!-------------------->
<div class="container">
	<div class="row">
		<div class="col-sm-12">
			<div class="d-flex j-content-center">
				<img class="mt-5" src="<?php echo get_template_directory_uri(); ?>/assets/images/server-star.png" alt="">
			</div>
			<div class="serverTime">
				<h2>Your website is not using any cache</h2>
				<h4>Please consider one of the following plugins</h4>
			</div>
		</div>
		<div class="col-sm-4">
			<div class="cacheBox white">
				<img class="w-100" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-image.jpg" alt="">
				<div class="d-flex mt-3">
					<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-singal-star.png" alt="">
					<div class="cacheHeading">
						<h4>Layer Slider</h4>
					</div>
					<img class="ml-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-singal-star.png" alt="">
				</div>
				<div class="cacheHeading">
					<p>All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. </p>
				</div>
			</div>
			<div class="d-flex spaceBetween">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-left.png" alt="">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-right.png" alt="">
			</div>
			<div class="cacheInfo dark">
				<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-review.png">
				<div class="cacheHeading d-inline-block">
					<h5>More Info</h5>
				</div>
			</div>
		</div>
		<div class="col-sm-4">
			<div class="cacheBox white">
				<img class="w-100" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-image.jpg" alt="">
				<div class="d-flex mt-3">
					<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-singal-star.png" alt="">
					<div class="cacheHeading">
						<h4>Layer Slider</h4>
					</div>
					<img class="ml-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-singal-star.png" alt="">
				</div>
				<div class="cacheHeading">
					<p>All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. </p>
				</div>
			</div>
			<div class="d-flex spaceBetween">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-left.png" alt="">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-right.png" alt="">
			</div>
			<div class="cacheInfo dark">
				<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-review.png">
				<div class="cacheHeading d-inline-block">
					<h5>More Info</h5>
				</div>
			</div>
		</div>
		<div class="col-sm-4">
			<div class="cacheBox white">
				<img class="w-100" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-image.jpg" alt="">
				<div class="d-flex mt-3">
					<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-singal-star.png" alt="">
					<div class="cacheHeading">
						<h4>Layer Slider</h4>
					</div>
					<img class="ml-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-singal-star.png" alt="">
				</div>
				<div class="cacheHeading">
					<p>All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. </p>
				</div>
			</div>
			<div class="d-flex spaceBetween">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-left.png" alt="">
				<img src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-right.png" alt="">
			</div>
			<div class="cacheInfo dark">
				<img class="mr-2" src="<?php echo get_template_directory_uri(); ?>/assets/images/cache-review.png">
				<div class="cacheHeading d-inline-block">
					<h5>More Info</h5>
				</div>
			</div>
		</div>
	</div>
</div>
<!-- Cache Section Code End-->
<!-------------------->

<?php get_footer();?>

