<?php
/*
 ==============================
            ADMIN PAGE
 ==============================
 */

function speedtest_add_admin_page()
{
    add_menu_page('Speed Test Theme Options', 'Speed Test', 'manage_options', 'speedtest_options', 'speedtest_theme_create_page', '', 110);

}

add_action('admin_menu', 'speedtest_add_admin_page');

function speedtest_theme_create_page()
{
    require_once get_template_directory() . '/inc/admin-page.php';
    locations_table_creator();
    hosting_table_creator();
}

function locations_table_creator()
{
global $wpdb;

$table_name = $wpdb->prefix . 'locations';
$charset_collate = $wpdb->get_charset_collate();

$sql = "CREATE TABLE $table_name (
        id int(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        loc text NOT NULL,
        url text NOT NULL) $charset_collate";

require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
dbDelta($sql);
$got = $wpdb->get_results("SELECT * FROM $table_name");
?>
    <h2>Locations</h2>
<form method="post" action="<?php echo get_template_directory_uri(); ?>/inc/save-locations.php">
<table id="tab">
    <thead>
    <tr>
        <th></th>
        <th>Location</th>
        <th>IP Address/URL</th>
        <th>Delete</th>
    </tr>
    </thead>
    <script>
        var result = <?php echo json_encode($got); ?>;
        var deletedArray = [];
        var tab = document.getElementById('tab');
        for (let i =0; i < result.length; i++){
            let z = document.createElement('tr');
            z.id = result[i].id;
            z.innerHTML = '<td><input type="hidden" name="result['+i+'][id]" value="'+result[i].id+'"></td>\n' +
                '            <td><input type="text" name="result['+i+'][loc]" value="'+result[i].loc+'"></td>\n' +
                '            <td><input type="text" name="result['+i+'][url]" value="'+result[i].url+'"></td>\n' +
                '            <td><input type="button" onclick="deleteRow('+result[i].id+')" value="Delete"></td>';
            tab.appendChild(z);
        }
        var index = result.length;
        var tab = document.getElementById('tab');
        function addNew(){
            $thisId = parseInt(result[result.length-1].id)+1;
            result.push({id:$thisId, loc:'', url:''});
            let x = document.createElement('tr');
            x.id = result[index].id;
            x.innerHTML = '<td><input type="hidden" name="result['+index+'][id]" value="'+result[index].id+'"></td>\n' +
                '            <td><input type="text" name="result['+index+'][loc]" value="'+result[index].loc+'"></td>\n' +
                '            <td><input type="text" name="result['+index+'][url]" value="'+result[index].url+'"></td>\n' +
                '            <td><input type="button" onclick="deleteRow('+result[index].id+')" value="Delete"></td>';
            tab.appendChild(x);
            index++;
        }
        function deleteRow(id) {
           let deleted = document.getElementById(id);
           tab.removeChild(deleted);
           result.splice(id, 1);
           let newid = parseInt(id);
           deletedArray.push(newid);
           let del = document.createElement('input');
           del.type = 'hidden';
           del.name = 'deleted[' + deletedArray.length + ']';
           del.value = deletedArray[deletedArray.length-1];
           tab.appendChild(del);
        }
    </script>
</table>
    <input type='button' value='Add New' onclick="addNew()">
    <input name="submit" type="submit" value="Save Changes">
</form>
    <?php
}
?>

<?php
    function hosting_table_creator()
    {
    global $wpdb;

    $table_name = $wpdb->prefix . 'hosting_companies';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
    id int(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
    name text NOT NULL,
    legal_name text NOT NULL) $charset_collate";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
    $got = $wpdb->get_results("SELECT * FROM $table_name");
    ?>
        <br>
    <h2>Hosting Comapnies</h2>
    <form method="post" action="<?php echo get_template_directory_uri(); ?>/inc/save-hosting.php">
        <table id="tab-2">
            <thead>
            <tr>
                <th></th>
                <th>Name</th>
                <th>Legal Name</th>
                <th>Delete</th>
            </tr>
            </thead>
            <script>
                var results_HC = <?php echo json_encode($got); ?>;
                var deletedArray_HC = [];
                let tab_HC = document.getElementById('tab-2');
                for (let i =0; i < results_HC.length; i++){
                    let z = document.createElement('tr');
                    z.id = results_HC[i].id;
                    z.innerHTML = '<td><input type="hidden" name="result['+i+'][id]" value="'+results_HC[i].id+'"></td>\n' +
                        '            <td><input type="text" name="result['+i+'][name]" value="'+results_HC[i].name+'"></td>\n' +
                        '            <td><input type="text" name="result['+i+'][legal_name]" value="'+results_HC[i].legal_name+'"></td>\n' +
                        '            <td><input type="button" onclick="deleteRow('+results_HC[i].id+')" value="Delete"></td>';
                    tab_HC.appendChild(z);
                }
                var index = results_HC.length;
                function addNew(){
                    $thisId = parseInt(results_HC[results_HC.length-1].id)+1;
                    results_HC.push({id:$thisId, name:'', legal_name:''});
                    let x = document.createElement('tr');
                    x.id = results_HC[index].id;
                    x.innerHTML = '<td><input type="hidden" name="results_HC['+index+'][id]" value="'+results_HC[index].id+'"></td>\n' +
                        '            <td><input type="text" name="results_HC['+index+'][name]" value="'+results_HC[index].name+'"></td>\n' +
                        '            <td><input type="text" name="results_HC['+index+'][legal_name]" value="'+results_HC[index].legal_name+'"></td>\n' +
                        '            <td><input type="button" onclick="deleteRow('+results_HC[index].id+')" value="Delete"></td>';
                    tab_HC.appendChild(x);
                    index++;
                }
                function deleteRow(id) {
                    let deleted = document.getElementById(id);
                    tab_HC.removeChild(deleted);
                    results_HC.splice(id, 1);
                    let newid = parseInt(id);
                    deletedArray_HC.push(newid);
                    let del = document.createElement('input');
                    del.type = 'hidden';
                    del.name = 'deleted_HC[' + deletedArray_HC.length + ']';
                    del.value = deletedArray_HC[deletedArray_HC.length-1];
                    tab_HC.appendChild(del);
                }
            </script>
        </table>
        <input disabled type="text" name="" id="" value="Other" style="margin-left: 7px;"><br><br>
        <input type='button' value='Add New' onclick="addNew()">
        <input name="submit" type="submit" value="Save Changes">
    </form>
<?php
}
?>

