<?php
get_header();
the_post();
?>

    <div class="container-fluid columnPadding">
        <div class="row">

            <div class="col-sm-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a
                                    href="<?php echo site_url(); ?>"><?php echo get_the_title( get_option( 'page_on_front' ) ) ?></a>
                        </li>
                        <li class="breadcrumb-item" aria-current="page"><a
                                    href="<?php echo get_post_type_archive_link( 'hosting_reviews' ); ?>"><?php echo REVIEWS_PAGE ?></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page"><?php the_title(); ?></li>
                    </ol>
                </nav>
            </div>

            <div class="col-sm-9">
                <div class="blogDetailBox">
                    <div class="col-sm-12">
                        <div class="singleDetail">
                            <h3><?php the_title(); ?></h3>
                        </div>
                    </div>
                    <div class="row m-0 bottomHolder">
                        <div class="col-sm-6 borderHolder">
                            <img class="singleUser" src="images/single-user.png" alt="">
                            <div class="singleDetail d-inline-block">
                                <h5><?php the_author_meta( 'display_name' ); ?></h5>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <img class="singleUser" src="images/detail-date.png" alt="">
                            <div class="singleDetail d-inline-block">
                                <h5><?php the_time( 'F j' ); ?></h5>
                            </div>
                        </div>
                    </div>
					<?php the_content(); ?>
                </div>
            </div>

            <div class="col-md-3">
                <div class="blueHostSideBar">
                    <div class="col-sm-12">
                        <div class="d-flex j-content-center">
                            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/siteground-logo.png"
                                 alt="">
                        </div>
                        <div class="cacheSidebar">
                            <div class="d-flex f-end">
                                <img class="cursorPointer"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/information-icon.png"
                                     alt="">
                            </div>
                            <div class="cacheSidebarHeading">
                                <h4>SiteGround</h4>
                            </div>
                        </div>
                        <button type="button" class="btn btn-primary speedButton">View Full Speed Report</button>
                    </div>


					<?php
					$hosting_companies = json_decode( get_option( 'vq_hosting_companies_details' ) );
					$selectedSlug      = get_post_meta( get_the_ID(), 'vq_review_hosting_company', true );
					$reviewHosting     = null;
					foreach ( $hosting_companies as $company ):
						if ( $company->slug === $selectedSlug ):
							$reviewHosting = $company;
						endif;
					endforeach;
					//                        echo "<pre style='color: #fff'>";
					//                        print_r($hosting_companies);
					//                        print_r($selected);
					//                        echo "</pre>";
					?>
                    <div class="d-flex spaceBetween">
                        <img class="cacheSidebarCornerLeft"
                             src="<?php echo get_template_directory_uri(); ?>/assets/images/bluehost-sidebar-corner-left.png"
                             alt="">
                        <img class="cacheSidebarCornerRight"
                             src="<?php echo get_template_directory_uri(); ?>/assets/images/bluehost-sidebar-corner-right.png"
                             alt="">
                    </div>

                    <div class="cacheSidebarInfo orange">
                        <div class="d-flex spaceBetween">
                            <div class="inline-flex">
                                <img class="webLocationIcon"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/web-location-icon.png"
                                     alt="">
                                <div class="cacheSidebarHeading">
                                    <h5>US (W)</h5>
                                </div>
                            </div>
                            <div class="inline-flex">
                                <div class="cacheSidebarHeading">
                                    <h6>56 <span>ms</span></h6>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="blueHostSideBar">
                    <div class="col-sm-12">
                        <div class="cacheSidebar mb-2 mt-0">
                            <div class="d-flex f-end">
                                <img class="cursorPointer"
                                     src="<?php echo get_template_directory_uri(); ?>/assets/images/information-icon.png"
                                     alt="">
                            </div>
                            <div class="cacheSidebarHeading">
                                <h4>Server Location</h4>
                            </div>
                        </div>
                    </div>


					<?php

					if ( isset( $reviewHosting ) && is_array( $reviewHosting->locations ) ) {
						foreach ( $reviewHosting->locations as $loc ):
							?>

                            <div class="d-flex spaceBetween">
                                <img class="cacheSidebarCornerLeft" src="<?php echo get_template_directory_uri(); ?>/assets/images/server-sidebar-corner-left.png" alt="">
                                <img class="cacheSidebarCornerRight" src="<?php echo get_template_directory_uri(); ?>/assets/images/server-sidebar-corner-right.png" alt="">
                            </div>
                            <div class="cacheSidebarInfo dark">
                                <div class="d-flex spaceBetween">
                                    <div class="inline-flex">
                                        <img class="webLocationIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/server-location-icon.png" alt="">
                                        <div class="serverSidebarHeading">
                                            <h5><?php echo $loc ?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>

						<?php
						endforeach;
					}

					?>

                </div>
                <div class="blueHostSideBar">
                    <div class="col-sm-12">
                        <div class="cacheSidebar mb-2 mt-0">
                            <div class="d-flex f-end">
                                <img class="cursorPointer" src="<?php echo get_template_directory_uri(); ?>/assets/images/information-icon.png" alt="">
                            </div>
                            <div class="cacheSidebarHeading">
                                <h4>Plans &amp; Pricing</h4>
                            </div>
                        </div>
                    </div>

	                <?php

	                if ( isset( $reviewHosting ) && is_array( $reviewHosting->packages ) ) {
		                foreach ( $reviewHosting->packages as $package ):
			                ?>

                            <div class="d-flex spaceBetween">
                                <img class="cacheSidebarCornerLeft" src="<?php echo get_template_directory_uri(); ?>/assets/images/server-sidebar-corner-left.png" alt="">
                                <img class="cacheSidebarCornerRight" src="<?php echo get_template_directory_uri(); ?>/assets/images/server-sidebar-corner-right.png" alt="">
                            </div>

                            <div class="cacheSidebarInfo dark">
                                <div class="d-flex j-content-center">
                                    <div class="inline-flex">
                                        <img class="webLocationIcon" src="<?php echo get_template_directory_uri(); ?>/assets/images/shared-icon.png" alt="">
                                        <div class="cacheSidebarHeading">
                                            <h6><?php echo $package->title ?></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="offerBox">
                                    <img class="boxTopLeftOther top" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-left.png" alt="">
                                    <div class="d-flex f-end">
                                        <img class="bestOffer" src="<?php echo get_template_directory_uri(); ?>/assets/images/best-offer.png" alt="">
                                    </div>
                                    <div class="offerHeading">
                                        <h4>Starting From</h4>
                                        <h2><span>$</span><?php echo $package->price ?></h2>
                                    </div>
                                    <img class="boxTopRightOther right" src="<?php echo get_template_directory_uri(); ?>/assets/images/box-top-right.png" alt="">
                                </div>
                            </div>

		                <?php
		                endforeach;
	                }

	                ?>

                </div>
            </div>
        </div>
    </div>

<?php
get_footer();
