(function ($) {
    var lmsLearners = $("#lms-learners");
    var courseSummeryHolder = $(".lms-summery-course");
    var lmsCheckoutForm = $("#lmsCheckoutForm");

    var learnerFormTemplate = $("#learnerTemplate").html();
    var singleCourseTemplate = $("#singleCourseTemplate").html();
    var lmsSummeryCourse = $("#lmsSummeryCourse").html();
    var lmsSummerySingleLearner = $("#lmsSummerySingleLearner").html();
    var promoValue = 0;
    var addLearnerBtn = $("#lms-add-learner");

    var learners = [];
    var pstatus = 'PENDING';
    var pid = -1;

    window.initializeLearners = function(obj, oid, ostatus) {
        if(obj === null && lmsLearners.length){
            initEvents();
            addEmptyLearner();
        } else if(lmsLearners.length){
            learners = obj;
            pid = oid;
            pstatus = ostatus;
        }

        renderLearnersPage();
    };

    function renderLearnersPage() {
        renderLearnersForm();
        renderOrderSummery();
    }

    function renderOrderSummery() {
        var selectedCourses = [];
        var uniqueId = [];
        var courseLearner = [];
        var totalCost = 0;

        learners.forEach(function (learner) {
            selectedCourses = selectedCourses.concat(learner.courses);
            learner.courses.forEach(function (course) {
                if (!courseLearner[course.id]) {
                    courseLearner[course.id] = [];
                }
                courseLearner[course.id].push(learner);
            })
        });
        selectedCourses = selectedCourses.filter(function (course) {
            if (uniqueId.indexOf(course.id) === -1) {
                uniqueId.push(course.id);
                return course;
            }
        });


        courseSummeryHolder.html("");
        selectedCourses.forEach(function (course) {
            var lmsSummeryCourseElem = $(lmsSummeryCourse);

            lmsSummeryCourseElem.find(".courseName").html(course.name);
            courseSummeryHolder.append(lmsSummeryCourseElem);

            courseLearner[course.id].forEach(function (learner, index) {
                var lmsSummerySingleElem = $(lmsSummerySingleLearner);
                lmsSummerySingleElem.find(".index").html(index + 1);
                lmsSummerySingleElem.find(".name").html(learner.fname);
                lmsSummerySingleElem.find(".email").html(learner.email);
                lmsSummerySingleElem.find(".phone").html(learner.phone);
                if(promoValue > 0) {
                    course.cost = Math.ceil(((100 - promoValue)/100) * course.cost);
                }
                lmsSummerySingleElem.find(".price").html(course.cost + " " + lmsSettings.vq_lms_settings_field_currency_symbol);
                totalCost += parseFloat(course.cost);
                courseSummeryHolder.append(lmsSummerySingleElem);
            });


        });

        $(".lms-total").html(totalCost + " " + lmsSettings.vq_lms_settings_field_currency_symbol);
        $(".lms-grand-total").html(totalCost + " " + lmsSettings.vq_lms_settings_field_currency_symbol);
    }

    function renderLearnersForm() {
        lmsLearners.html("");
        learners.forEach(function (item, index) {
            var learnerFormElement = $(learnerFormTemplate);
            learnerFormElement.find(".lmsIndex").html(index + 1);
            learnerFormElement.find("input[name='fname']").val(item.fname);
            learnerFormElement.find("input[name='email']").val(item.email);
            learnerFormElement.find("input[name='confirmEmail']").val(item.confirmEmail);
            learnerFormElement.find("input[name='phone']").val(item.phone);


            if (index == 0) {
                learnerFormElement.find(".lms-learner-remove span").html("");
            } else {
                learnerFormElement.find(".lms-learner-remove span").click(removeLearner.bind(index));
            }
            learnerFormElement.find(".lms-courses-select-btn").click(showAddMoreCourses.bind(item));
            learnerFormElement.find("input").keyup(updateLearnerInfo.bind(item));
            learnerFormElement.find("input").change(updateLearnerInfo.bind(item));

            var couseHolder = learnerFormElement.find(".lms-all-course-holder");
            couseHolder.html("");
            if (item.courses.length === 0) {
                couseHolder.html('<div class="lms-single-course-holder"> \
                    <span class="name">No course selected.</span> \
                <div class="clear"></div> \
                    </div>')
            }
            item.courses.forEach(function (course) {
                var singleCourseElement = $(singleCourseTemplate);
                course.cost = (course.cost) ? course.cost : lmsSettings.vq_lms_settings_field_general_price;

                singleCourseElement.find(".name").html(course.name)
                singleCourseElement.find(".price").html(course.cost + " " + lmsSettings.vq_lms_settings_field_currency_symbol)
                singleCourseElement.find(".remove").click(removeCourse.bind(item, course.id));
                couseHolder.append(singleCourseElement);
            });


            item.element = learnerFormElement;
            lmsLearners.append(learnerFormElement);
        })

        if(pstatus == 'PAID') {
            lmsLearners.find("input").each(function(index, item){
                $(item).attr('disabled', true);
            });
            $("span.remove").remove();
            $("#lmsProcessPayment")
                .after('<div class="paid">PAID</div>')
                .attr('disabled', true);
            $("#lmsProcessPayment").remove();

        }
        $("#ldr").remove();
    }

    function removeCourse(courseId) {
        this.courses = this.courses.filter(function (course) {
            return course.id != courseId;
        });
        renderLearnersPage();
    }

    function showAddMoreCourses(e) {
        e.preventDefault();
        var select = this.element.find(".lms-courses-select");
        this.element.find(".lms-courses-select-btn").hide();
        select.show();
        select.find("select").chosen({
            no_results_text: "Oops, no courses found!"
        }).change(onCourseSelected.bind(this));
    }

    function onCourseSelected(e) {
        var selectedCourse = courses.filter(function (item) {
            return item.id == e.target.value
        });

        if (selectedCourse.length > 0) {
            if (this.courses.indexOf(selectedCourse[0]) === -1)
                this.courses.push(selectedCourse[0]);
        }

        this.element.find(".lms-courses-select").hide();
        this.element.find(".lms-courses-select-btn").show();

        renderLearnersPage();
    }

    function updateLearnerInfo(e) {
        var input = $(e.target);
        this[input.attr("name")] = input.val();
        renderOrderSummery();
    }

    function removeLearner() {
        learners.splice(this, 1);
        renderLearnersPage();
    }

    function addEmptyLearner() {
        var lerner = {
            fname: "",
            email: "",
            confirmEmail: "",
            phone: "",
            courses: []
        };

        learners.push(lerner);
        renderLearnersPage();
    }

    function initEvents() {
        addLearnerBtn.click(function (e) {
            addEmptyLearner();
        });
    }




    lmsCheckoutForm.submit(function (e) {
        e.preventDefault();

        var paymentBtn = $("#lmsProcessPayment");

        var learnersWithNoCourse = learners.filter(function (learner) {
            return learner.courses.length === 0;
        });

        var learnersMismatchEmails = learners.filter(function (learner) {
            return learner.email !== learner.confirmEmail;
        });

        if (learnersWithNoCourse.length > 0) {
            
            $.toast({
                text: "Please select courses with all learners.", // Text that is to be shown in the toast
                heading: '', // Optional heading to be shown on the toast
                icon: 'error', // Type of toast icon
                showHideTransition: 'fade', // fade, slide or plain
                allowToastClose: true, // Boolean value true or false
                hideAfter: 4000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                position: 'top-right', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
    
                textAlign: 'left',  // Text alignment i.e. left, right or center
                loader: false,  // Whether to show loader or not. True by default
                loaderBg: '#9EC600',  // Background color of the toast loader
                beforeShow: function () {}, // will be triggered before the toast is shown
                afterShown: function () {}, // will be triggered after the toat has been shown
                beforeHide: function () {}, // will be triggered before the toast gets hidden
                afterHidden: function () {}  // will be triggered after the toast has been hidden
            });

            return;
        }

        if (learnersMismatchEmails.length > 0) {
            
            $.toast({
                text: "Confirm email mismatched.", // Text that is to be shown in the toast
                heading: '', // Optional heading to be shown on the toast
                icon: 'error', // Type of toast icon
                showHideTransition: 'fade', // fade, slide or plain
                allowToastClose: true, // Boolean value true or false
                hideAfter: 4000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                position: 'top-right', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
    
                textAlign: 'left',  // Text alignment i.e. left, right or center
                loader: false,  // Whether to show loader or not. True by default
                loaderBg: '#9EC600',  // Background color of the toast loader
                beforeShow: function () {}, // will be triggered before the toast is shown
                afterShown: function () {}, // will be triggered after the toat has been shown
                beforeHide: function () {}, // will be triggered before the toast gets hidden
                afterHidden: function () {}  // will be triggered after the toast has been hidden
            });

            return;
        }

        if(!$("#accepted_terms").is(':checked')) {

            $.toast({
                text: "Please accept the Terms and Conditions.", // Text that is to be shown in the toast
                heading: '', // Optional heading to be shown on the toast
                icon: 'error', // Type of toast icon
                showHideTransition: 'fade', // fade, slide or plain
                allowToastClose: true, // Boolean value true or false
                hideAfter: 4000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                position: 'top-right', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
    
                textAlign: 'left',  // Text alignment i.e. left, right or center
                loader: false,  // Whether to show loader or not. True by default
                loaderBg: '#9EC600',  // Background color of the toast loader
                beforeShow: function () {}, // will be triggered before the toast is shown
                afterShown: function () {}, // will be triggered after the toat has been shown
                beforeHide: function () {}, // will be triggered before the toast gets hidden
                afterHidden: function () {}  // will be triggered after the toast has been hidden
            });

            return;
        }

        var data = {};

        data.data = learners;
        data.pcode = $("#pcode-value").val();
        data.terms = $("#accepted_terms").val();
        data.id = parseInt(pid);


        paymentBtn.html("Please wait.");
        paymentBtn.addClass("disabled");

        $.post(ajaxurl, {
            action: "processOrder",
            data: JSON.stringify(data)
        }, function (data){
            if(data == "Unable to process your request"){
                alert(data);
                paymentBtn.html("Proceed to payment");
                paymentBtn.removeClass("disabled");
            } else {
                $("#paymentrequest").val(data);
                $("#payserv").submit();
            }
        });

    });

    var courseList = $("#course_list");
    courseList.html("");
    if(typeof crsList != 'undefined') {
        crsList.forEach(function(item) {
            var option = "<option value='" + item + "'>" + item +"</option>";
            courseList.append(option);
        });
    }


    $("#pcode-value").change(function() {
        $("#promo-loader").show();
        $("#pcode-value").attr('disabled', true);
        promoValue = 0;
        var val = $("#pcode-value").val();
        if($("#pcode-value").val() != "") {
            $.post(ajaxurl, {
                action: "check_promo",
                data: val
            }, function (data){
                $("#promo-loader").hide();
                $("#pcode-value").attr('disabled', false);
                if(data < 0) {
                    
            $.toast({
                text: "Invalid Promo Code", // Text that is to be shown in the toast
                heading: '', // Optional heading to be shown on the toast
                icon: 'error', // Type of toast icon
                showHideTransition: 'fade', // fade, slide or plain
                allowToastClose: true, // Boolean value true or false
                hideAfter: 4000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
                stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
                position: 'top-right', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
    
                textAlign: 'left',  // Text alignment i.e. left, right or center
                loader: false,  // Whether to show loader or not. True by default
                loaderBg: '#9EC600',  // Background color of the toast loader
                beforeShow: function () {}, // will be triggered before the toast is shown
                afterShown: function () {}, // will be triggered after the toat has been shown
                beforeHide: function () {}, // will be triggered before the toast gets hidden
                afterHidden: function () {}  // will be triggered after the toast has been hidden
            });

                    $("#pcode-value").val('');
                } else {
                    promoValue = parseInt(data);
                    renderLearnersPage();
                }
            });
        }

    });

    // $("#accepted_terms").on('click', function() {
    //     if($(this).is(':checked')) {
    //         $("#lmsProcessPayment").prop('disabled', false);
    //     } else {
    //         $("#lmsProcessPayment").attr('disabled', true);
    //     }
    // });


})(jQuery);

// form validation

function check(course){

    var fname = document.getElementById("fname").value;
    var lname = document.getElementById("lname").value;
    var company = document.getElementById("company").value;
    var mail = document.getElementById("mail").value;
    var job = document.getElementById("job").value;
    var contact = document.getElementById("contact").value;

    if(fname === ''){
                                alert("first name is required.");
    } else if(lname === ''){
                                alert("last name is required.");
    } else if(company === ''){
                                alert("company name is required.");
    } else if(mail === ''){
                                alert("email id is required.");
    } else if(job === ''){
                                alert("job title is required.");
    } else if(contact === ''){
                                alert("contact number is required.");
    } else if(course === ''){
        alert("Please select courses to proceed.");
    }
}