<?php
get_header();
$tax = get_query_var('course');




$term = get_term_by('slug', $tax, 'vq_course_taxonomy');

$imgt = wp_get_attachment_url(get_term_meta($term->term_id, 'vq_course_taxonomy-image-id', true)) ;

$args = array(
	'post_type' => 'vq_course',
	'posts_per_page' => '-1',
	'tax_query'      => array(
		array(
			'taxonomy' => 'vq_course_taxonomy',
			'field'    => 'slug',
			'terms'    => $tax
		),
	),
);
$courses = new WP_Query($args);
$courses1 = $courses;
$children = get_term_children( $term->term_id, 'vq_course_taxonomy' );


$crsList = array();

while($courses1->have_posts()) {
    $courses1->the_post();

	$crsList[] = get_the_title();
}

echo "<script> crsList = " . json_encode($crsList) . " </script>";

$page = get_page_by_path('lms-courses');


?>
    <div class="bootstrap-iso">
        <div class="e-learning-banner" style="background-image: url(<?php echo $imgt ?>)">
            <div class="container">
                <div class="row">
                    <div class="e-learning-heading">
                        <h2><?php echo $term->name ?></h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="lms-breadcrumbs">
            <div class="container">
                <div class="row">
                    <p><a href="<?php echo "/lms"?>">LMS</a> > <?php echo $term->name; ?></p>
                </div>
            </div>
        </div>
        <div class="learning-profile-bg">
            <div class="container">
                <div class="row">
                    <?php echo $term->description ?>
                </div>
            </div>
        </div>


        <div class="container">
            <div class="row">
                <div class="col-sm-8">
                    <?php if(count($children) > 0){ ?>
                    <?php foreach($children as $child){ ?>
                        <div class="course-box">
                        <div class="col-sm-3 col-padding" style="line-height: 0;">
                            <img src="<?php echo wp_get_attachment_url(get_term_meta($child, 'vq_course_taxonomy-image-id', true)) ?>" alt="" style="height: 160px;">
                        </div>
                        <div class="col-sm-6 col-padding">

                            <?php
                            $limit = 165;
                            $field = get_term_field('description', $child);
                            if (strlen($field) > $limit)
                            $field = substr($field, 0, strrpos(substr($field, 0, $limit), ' ')) . '...';
                            ?>

                            <div class="course-heading" style="padding-left: 6px; line-height: normal">
                                <h3><?php echo get_term_name($child, 'vq_course_taxonomy') ?> </h3>
                                <p style="font-size: 14px;"><?php echo $field ?></p>
                            </div>
                        </div>
                        <div class="col-sm-3 col-padding">
                            <div class="download-course-box">
                                <div class="course-heading" >
                                    <!--<h4><a href="<?php /*echo get_term_meta($child, 'vq_course_ct_tax_redirect', true) */?>">Download <br>course list</a></h4>-->
                                    <h4><a href="<?php echo get_page_link(get_page_by_path('download-all')); ?>">Download <br>course list</a></h4>
                                </div>
                            </div>
                        </div>
                        <div class="clear"></div>
                    </div>
                    <?php }?>
                    <?php } else echo 'No Courses Found!'; ?>
                </div>
                <div class="col-sm-4">
	                <?php echo  do_shortcode('[contact-form-7 id="6212" title="Inquiry Form"]'); ?>
                </div>
            </div>
        </div>

	    <?php echo do_shortcode('[vq_short_banner 
	        txtClr="#fff" 
	        btnClr="#fff" 
	        bgClr="#f89f18" 
	        btnBg="#2898c4" 
	        btnTxt="Download Full List Of Courses" 
	        txt="Not sure which course to take?"]'); ?>

	    <?php echo do_shortcode('[vq_short_banner 
	        txtClr="#fff" 
	        btnClr="#fff" 
	        bgClr="#2898c4" 
	        btnBg="#f89f18" 
	        btnLink="lms-checkout"
	        btnTxt="Sign Up today" 
	        txt="Ready to begin?"]'); ?>

    </div>
<?php
get_footer();
?>