<?php

	/***************************************************************************************
		Group the Courses by category
	***************************************************************************************/
	function get_course_by_category($limit=12){
		global $wpdb;
		$query_str = "SELECT post.*, relation.object_id, relation.term_taxonomy_id, taxonomy.parent as cat_parent_id, term.term_id as cat_id, term.name as cat_name
				FROM ap_posts AS post 
				LEFT JOIN ap_term_relationships relation ON post.ID=relation.object_id
				LEFT JOIN ap_term_taxonomy AS taxonomy ON relation.term_taxonomy_id=taxonomy.term_taxonomy_id
				LEFT JOIN ap_terms AS term ON taxonomy.term_id=term.term_id
				WHERE post.post_status='publish' 
				AND post.post_type ='project'
				AND term.term_id!=''
				ORDER BY taxonomy.parent ASC, post.post_title ASC
				LIMIT {$limit}
				";
		$total_rows	= $wpdb->get_results($query_str, OBJECT);
		
		$category_list = array();
		foreach($total_rows as $key=>$val){
			$category_list[$val->cat_id]['name'] = $val->cat_name;
			$category_list[$val->cat_id]['cat_parent'] = $val->cat_parent_id;
			$category_list[$val->cat_id]['item'][] = $val;
		}
		
		return $category_list;
	}
	
	/***************************************************************************************
		Get Course then filter by category
	***************************************************************************************/
	function get_course_filter_category($cat_id){
		global $wpdb;
		$query_str = "SELECT post.*, relation.object_id, relation.term_taxonomy_id, taxonomy.parent as cat_parent_id, term.term_id as cat_id, term.name as cat_name
				FROM ap_posts AS post 
				LEFT JOIN ap_term_relationships relation ON post.ID=relation.object_id
				LEFT JOIN ap_term_taxonomy AS taxonomy ON relation.term_taxonomy_id=taxonomy.term_taxonomy_id
				LEFT JOIN ap_terms AS term ON taxonomy.term_id=term.term_id
				WHERE post.post_status='publish' 
				AND post.post_type ='project'
				AND term.term_id={$cat_id}
				ORDER BY post.post_title ASC
				";
		$total_rows	= $wpdb->get_results($query_str, OBJECT);
		return $total_rows;
	}
	
	function get_category_courses(){
			$query_str = "
				SELECT term_taxonomy.*, terms.* FROM ap_term_taxonomy AS term_taxonomy
				LEFT JOIN ap_terms AS terms ON term_taxonomy.term_id=terms.term_id
				WHERE terms.term_id=20
				";
	}
	
	/***************************************************************************************
		Get All Custom Course
	***************************************************************************************/
	function get_custom_course($keyword=''){
		global $wpdb;
		$keyword	= '%'. strtolower($keyword) .'%';
		$query_str = "SELECT post.*, relation.object_id, relation.term_taxonomy_id, taxonomy.parent as cat_parent_id, (SELECT name FROM ap_terms WHERE term_id=taxonomy.parent LIMIT 1) as cat_parent_name, term.term_id as cat_id, term.name as cat_name
				FROM ap_posts AS post 
				LEFT JOIN ap_term_relationships relation ON post.ID=relation.object_id
				LEFT JOIN ap_term_taxonomy AS taxonomy ON relation.term_taxonomy_id=taxonomy.term_taxonomy_id
				LEFT JOIN ap_terms AS term ON taxonomy.term_id=term.term_id
				WHERE post.post_status='publish' 
				AND post.post_type ='all-courses'
				AND (LOWER(post.post_title) LIKE '%s' OR LOWER(post.post_content) LIKE '%s')
				ORDER BY post.post_title ASC
				";

		$query_str	= $wpdb->prepare($query_str, $keyword, $keyword);
		$total_rows	= $wpdb->get_results($query_str, OBJECT);
		return $total_rows;
	}

	/***************************************************************************************
		Verify Certificate Number
	***************************************************************************************/
	function verify_cert_number($certid=''){
		global $wpdb;
		$query_str = "SELECT post.*, postmeta.post_id, postmeta.meta_key, postmeta.meta_value FROM ap_posts AS post LEFT JOIN ap_postmeta AS postmeta ON post.ID=postmeta.post_id WHERE post.post_type='certificate' AND post.post_status='publish' AND postmeta.meta_key='cert_number' AND postmeta.meta_value='%s' LIMIT 1";
		$query_str	= $wpdb->prepare($query_str, $certid);
		return $wpdb->get_row($query_str, OBJECT);
	}
	
	
	/***************************************************************************************
		Get the URL for course category
	***************************************************************************************/
	function get_course_category_url($id){
		global $wpdb;
		$row = $wpdb->get_row("SELECT slug FROM ap_terms WHERE term_id={$id} LIMIT 1", OBJECT);
		return get_site_url() . '/project_category/' . $row->slug;
	}

	/***************************************************************************************
		Get the Title for course category
	***************************************************************************************/
	function get_course_category_title($id){
		global $wpdb;
		$row = $wpdb->get_row("SELECT name FROM ap_terms WHERE term_id={$id} LIMIT 1", OBJECT);
		return $row->name;
	}
	
	/***************************************************************************************
		Course Thumb
	***************************************************************************************/
	function get_course_thumb($id){
		$id = (int) $id;
		if(has_post_thumbnail($id)){
			return get_the_post_thumbnail($id, 'medium');
		}
		return '<img src="/wp-content/themes/apex/images/domain/noimage.jpg" />';
	}

	/***************************************************************************************
		Post Thumb
	***************************************************************************************/
	function get_post_thumb($id){
		$id = (int) $id;
		if(has_post_thumbnail($id)){
			return get_the_post_thumbnail($id, 'medium');
		}
		return '<img src="/wp-content/themes/apex/images/inugget-no-image.png" />';
	}
	
	
	/***************************************************************************************
		Course Breadcrumbs
	***************************************************************************************/
	function course_breadcrumbs(){
		global $wpdb;
		$breadcrumbs_arr = array('<a href="/"><span class="fa fa-home fa-lg"></span></a>', );
		
		$slug		= end(explode('/', trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/')));
		$post_id	= get_the_ID();
		
		/*	Check if Category then return the categorty title and category parent	*/
		if( preg_match('/\/project_category\/+/i', $_SERVER['REQUEST_URI']) ){
			$breadcrumbs_arr[] = '<a href="/courses">Courses</a>';
			
			$q_category		= "SELECT terms.term_id,terms.slug,terms.name,terms.slug,taxonomy.parent as parent_id,(SELECT name FROM ap_terms WHERE term_id=taxonomy.parent) as parent_title FROM ap_terms AS terms LEFT JOIN ap_term_taxonomy AS taxonomy ON terms.term_id=taxonomy.term_id WHERE terms.slug='{$slug}'";
			$q_category_row	= $wpdb->get_row($q_category, OBJECT);
			if($q_category_row){
				if( $q_category_row->parent_id ){
					$breadcrumbs_arr[] = '<a href="'. get_course_category_url($q_category_row->parent_id) .'">'. $q_category_row->parent_title .'</a>';
				}
				$breadcrumbs_arr[] = $q_category_row->name;
			}
		}
		
		
		/*	Check if Course Innerpage then return the course name, category and categort parent	*/
		if( preg_match('/\/course\/+/i', $_SERVER['REQUEST_URI']) ){
			$breadcrumbs_arr[] = '<a href="/courses">Courses</a>';
			
			$q_course = "SELECT post.ID, post.post_title, relation.object_id, relation.term_taxonomy_id, taxonomy.parent as cat_parent_id,(SELECT name FROM ap_terms WHERE term_id=taxonomy.parent) as cat_parent_title, term.term_id as cat_id, term.name as cat_name
						FROM ap_posts AS post 
						LEFT JOIN ap_term_relationships AS relation ON post.ID=relation.object_id
						LEFT JOIN ap_term_taxonomy AS taxonomy ON relation.term_taxonomy_id=taxonomy.term_taxonomy_id
						LEFT JOIN ap_terms AS term ON taxonomy.term_id=term.term_id
						WHERE post.post_status='publish'
						AND post.post_type ='project'
						AND post.ID={$post_id}
						LIMIT 1";
			$q_course_row	= $wpdb->get_row($q_course, OBJECT);
			if($q_course_row){
				if( $q_course_row->cat_parent_id ){
					$breadcrumbs_arr[] = '<a href="'. get_course_category_url($q_course_row->cat_parent_id) .'">'. $q_course_row->cat_parent_title .'</a>';
				}
				if( $q_course_row->cat_id ){
					$breadcrumbs_arr[] = '<a href="'. get_course_category_url($q_course_row->cat_id) .'">'. $q_course_row->cat_name .'</a>';
				}
				//$breadcrumbs_arr[] = $q_course_row->post_title;
				$breadcrumbs_arr[] = ( strlen($q_course_row->post_title) >= 50) ? substr($q_course_row->post_title,0,47).'...' : $q_course_row->post_title;
			}
		}
		
		
		/*	Check if Course landing page*/
		if(trim($_SERVER['REQUEST_URI'],'/') == 'courses' || trim($_SERVER['REQUEST_URI'],'/') == 'course'){
			$breadcrumbs_arr[] = get_the_title();
		}
		
		
		/*	Check if Course sub page*/			
		if(trim($_SERVER['REQUEST_URI'],'/') != 'courses' AND trim($_SERVER['REQUEST_URI'],'/') != 'course'){
			if( preg_match('/\/courses\/+/i', $_SERVER['REQUEST_URI']) ){
				$breadcrumbs_arr[] = '<a href="/courses">Courses</a>';
				$breadcrumbs_arr[] = get_the_title();
			}
		}

		/*	Check if iNugget/Webinar/Forum*/			
		if( preg_match('/\/inugget\/+/i', $_SERVER['REQUEST_URI']) || preg_match('/\/friday-forum\/+/i', $_SERVER['REQUEST_URI']) || preg_match('/\/webinar\/+/i', $_SERVER['REQUEST_URI'])){
			$breadcrumbs_arr[] = '<a href="/free-online-resources/">Free Online Resources</a>';
			$breadcrumbs_arr[] = post_type_archive_title('',false);
		}

		/*	Check if BLOG*/			
		if( preg_match('/\/blog\/+/i', $_SERVER['REQUEST_URI']) == true AND preg_match('/\/category\/blog\/+/i', $_SERVER['REQUEST_URI']) == false ){
			//$breadcrumbs_arr[] = '<a href="/free-online-resources/">Free Online Resources</a>';
			$breadcrumbs_arr[] = '<a href="/blog/">Blog</a>';
			$breadcrumbs_arr[] = get_the_title();
		}

		/*	Check if BLOG Category*/			
		if( preg_match('/\/category\/blog\/+/i', $_SERVER['REQUEST_URI']) ){
			//$breadcrumbs_arr[] = '<a href="/free-online-resources/">Free Online Resources</a>';
			$breadcrumbs_arr[] = '<a href="/blog/">Blog</a>';
			if($_SERVER['REQUEST_URI'] != '/category/blog/'){
				$breadcrumbs_arr[] = single_cat_title("", false);;
			}
		}
		
		$trail = implode("&nbsp;&nbsp;<span class='fa fa-angle-right'></span>&nbsp;&nbsp;", $breadcrumbs_arr);
		//return ( strlen($trail) >= 550) ? substr($trail,0,547).'...' : $trail;
		return $trail;
	}

	
	
	/***************************************************************************************
		Get the URL for course category
	***************************************************************************************/
	function get_course_calendar(){
		global $wpdb;
		/* $query_str	=	"SELECT post.ID, post.post_title, postmeta.meta_key, postmeta.meta_value, cfs_values.field_id, cfs_values.base_field_id, SUBSTRING(cfs_values.hierarchy, 1, CHAR_LENGTH(cfs_values.hierarchy) - 1) AS base_hierarchy, cfs_values.hierarchy,
						postmeta.meta_value as sched_date_start,
						(SELECT 2_postmeta.meta_value FROM ap_cfs_values AS 2_cfs_values LEFT JOIN ap_postmeta as 2_postmeta ON 2_cfs_values.meta_id=2_postmeta.meta_id WHERE 2_postmeta.meta_key='sched_date_end' AND 2_cfs_values.post_id=post.ID AND 2_cfs_values.base_field_id=cfs_values.base_field_id AND 2_cfs_values.hierarchy LIKE concat(base_hierarchy,'%') ) as sched_date_end,
						(SELECT meta_value FROM ap_postmeta WHERE meta_key='sched_location' AND post_id=post.ID LIMIT 1) as sched_location
						FROM ap_posts AS post
						LEFT JOIN ap_cfs_values AS cfs_values ON post.id=cfs_values.post_id
						LEFT JOIN ap_postmeta AS postmeta ON cfs_values.meta_id=postmeta.meta_id
						WHERE post.post_type='project'
						AND post.post_status='publish'
						AND postmeta.meta_key='sched_date_start'
						ORDER BY sched_date_start ASC
						"; */
						
		$query_str	=	"SELECT * FROM (
							SELECT post.ID, post.post_type, post.post_title, postmeta.meta_key, postmeta.meta_value, cfs_values.field_id, cfs_values.base_field_id, SUBSTRING(cfs_values.hierarchy, 1, CHAR_LENGTH(cfs_values.hierarchy) - 1) AS base_hierarchy, cfs_values.hierarchy,
							postmeta.meta_value as sched_date_start,
							(SELECT 2_postmeta.meta_value FROM ap_cfs_values AS 2_cfs_values LEFT JOIN ap_postmeta as 2_postmeta ON 2_cfs_values.meta_id=2_postmeta.meta_id WHERE 2_postmeta.meta_key='sched_date_end' AND 2_cfs_values.post_id=post.ID AND 2_cfs_values.base_field_id=cfs_values.base_field_id AND 2_cfs_values.hierarchy LIKE concat(base_hierarchy,'%') ) as sched_date_end,
							(SELECT meta_value FROM ap_postmeta WHERE meta_key='sched_location' AND post_id=post.ID LIMIT 1) as sched_location 
							FROM ap_posts AS post
							LEFT JOIN ap_cfs_values AS cfs_values ON post.id=cfs_values.post_id
							LEFT JOIN ap_postmeta AS postmeta ON cfs_values.meta_id=postmeta.meta_id
							WHERE (post.post_type='project' OR post.post_type='friday-forum' OR post.post_type='webinar')
							AND post.post_status='publish'
							AND (postmeta.meta_key='sched_date_start' OR postmeta.meta_key='friday_forum_date' OR postmeta.meta_key='webinar_date')
						) AS InnerTable
						WHERE (sched_date_start >= CURDATE() OR sched_date_end >= CURDATE())
						ORDER BY sched_date_start ASC
						";
						
		$rows = $wpdb->get_results($query_str, OBJECT);
		
		$data = array();
		foreach($rows as $key=>$val){
			list($start_year,$start_month,$start_day) = explode('-',$val->sched_date_start);
			$data[$start_year][$start_month][] = $val;
		}
		return $data;
	}
	
	
	/***************************************************************************************
		Get Course Domain
	***************************************************************************************/
	function get_course_domain($id){
		global $wpdb;		
		$query_str = "SELECT post.ID, relation.object_id, relation.term_taxonomy_id, taxonomy.parent as cat_parent_id, term.term_id as cat_id, term.name as cat_name
					FROM ap_posts AS post 
					LEFT JOIN ap_term_relationships AS relation ON post.ID=relation.object_id
					LEFT JOIN ap_term_taxonomy AS taxonomy ON relation.term_taxonomy_id=taxonomy.term_taxonomy_id
					LEFT JOIN ap_terms AS term ON taxonomy.term_id=term.term_id
					WHERE post.post_status='publish'
					AND post.post_type ='project'
					AND post.ID={$id}
					LIMIT 1
					";
		$row = $wpdb->get_row($query_str, OBJECT);
				
		$course_domain[20]	= array('ID'=>$row->cat_parent_id, 'cat_name'=>'Behavioral Exellence', 'class'=>'domain_gray', 'thumb'=> 'banner-Thumb4.png', 'banner'=> 'banner-Domain4.jpg');
		$course_domain[19]	= array('ID'=>$row->cat_parent_id, 'cat_name'=>'Business Process Exellence', 'class'=>'domain_blue', 'thumb'=> 'banner-Thumb3.png', 'banner'=> 'banner-Domain3.jpg');
		$course_domain[22]	= array('ID'=>$row->cat_parent_id, 'cat_name'=>'Corporate Sustainability & Governance', 'class'=>'domain_green', 'thumb'=> 'banner-Thumb5.png', 'banner'=> 'banner-Domain5.jpg');
		$course_domain[18]	= array('ID'=>$row->cat_parent_id, 'cat_name'=>'IT Exellence', 'class'=>'domain_red', 'thumb'=> 'banner-Thumb2.png', 'banner'=> 'banner-Domain2.jpg');
		$course_domain[21]	= array('ID'=>$row->cat_parent_id, 'cat_name'=>'Standards & Compliance', 'class'=>'domain_yellow', 'thumb'=> 'banner-Thumb1.png', 'banner'=> 'banner-Domain1.jpg');
		$course_domain[31]	= array('ID'=>$row->cat_parent_id, 'cat_name'=>'Development Management System', 'class'=>'domain_purple', 'thumb'=> 'banner-Thumb1.png', 'banner'=> 'banner-Domain1.jpg');
		
		
		return $course_domain[ $row->cat_parent_id ];
	}

	
	function get_current_category(){
		global $wpdb;
		$cat_slug = end(explode('/', trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/')));
		$query_str = "SELECT post.ID, relation.object_id, relation.term_taxonomy_id, taxonomy.parent as cat_parent_id, term.term_id as cat_id, term.name as cat_name, term.slug as slug
					FROM ap_posts AS post 
					LEFT JOIN ap_term_relationships AS relation ON post.ID=relation.object_id
					LEFT JOIN ap_term_taxonomy AS taxonomy ON relation.term_taxonomy_id=taxonomy.term_taxonomy_id
					LEFT JOIN ap_terms AS term ON taxonomy.term_id=term.term_id
					WHERE post.post_status='publish'
					AND post.post_type ='project'
					AND term.slug='{$cat_slug}'
					LIMIT 1
					";
		$row = $wpdb->get_row($query_str, OBJECT);
		if(!empty($row->slug)){
			return $row->cat_id;
		}
		return false;
	}
	
	
	/***************************************************************************************
		Display Course Calendar
	***************************************************************************************/
	function display_course_calendar(){
		$data = '';
		$get_course_calendar = get_course_calendar();
		$dynamic_months = array('01'=>'Jan','02'=>'Feb','03'=>'Mar','04'=>'Apr','05'=>'May','06'=>'Jun','07'=>'Jul','08'=>'Aug','09'=>'Sep','10'=>'Oct','11'=>'Nov','12'=>'Dec');
		
		$data .= '<script type="text/javascript" defer>';
		$data .= 	'jQuery(function(){';
						foreach($get_course_calendar as $cal_years_key=>$cal_years){
							$active_month = ($cal_years_key == date('Y')) ? (intval(date('m'))-1) : 0;
							$data .= 'jQuery(".jquery-calendar-tabs-'. $cal_years_key .'").tabs({active:'. $active_month .'});';
						}
		$data .= 	'});';
		$data .= '</script>';

		
		$data .= '<div id="calendar-module" class="calendar-module">';
		$data .= '<div class="calendar-header">';
		$data .= 	'<h3>Calendar</h3>';
		$data .= 	'<select name="calendar_location" class="calendar_location custom-select">';
						$data .= '<option value="all">All Locations</option>';
						foreach(getAllCourseLocation() as $loc_val){
							$data .= '<option value="'. strtolower(preg_replace('/[^\da-z]/i', '-', $loc_val->location)) .'">'. $loc_val->location .'</option>';
						}
		$data .= 	'</select>';

		$data .= 	'<select name="calendar_post_type" class="calendar_post_type custom-select">';
						$data .= '<option value="all">All Events</option>';
						$data .= '<option value="project">Trainings</option>';
						$data .= '<option value="webinar">Webinars</option>';
						$data .= '<option value="friday-forum">Friday Forums</option>';
		$data .= 	'</select>';
		
		$data .= 	'<select name="calendar_years" class="calendar_years custom-select">';
						$option_count = 0;
						foreach($get_course_calendar as $cal_years_key=>$cal_years){
							if($cal_years_key==date('Y')){
								$data .= '<option value="'. $option_count .'" selected="selected">'. $cal_years_key .'</option>'; 
							}else{
								$data .= '<option value="'. $option_count .'">'. $cal_years_key .'</option>'; 
							}
							$option_count++;
						}
		$data .= 	'</select>';
		
		$data .= 	'<input type="text" name="calendar_keyword" class="calendar_keyword" placeholder="Search..."/>';
		
		$data .= 	'<div class="clearfix"></div>';
		$data .= '</div>';
		
		$data .= '<div class="calendar-bxSlider">';
			foreach($get_course_calendar as $cal_years_key=>$cal_years){
				
				$data .= '<div class="calendar-year-wrapper calendar-year-'. $cal_years_key .'">';
				$data .= 	'<div class="jquery-calendar-tabs-'. $cal_years_key .'">';
				$data .= 		'<ul>';
									foreach($dynamic_months as $key=>$val){
										$data .= '<li><a href="#tabs-'. intval($key) .'" class="no_smooth_scroll">'. $val .'</a></li>';
									}
				$data .= 		'</ul>';
								foreach($dynamic_months as $key=>$val){
									$data .= '<div id="tabs-'. intval($key) .'">';
									$data .= 	'<div class="table-wrapper">';
									$data .= 	'<table border="0">';
												if( count($cal_years[$key]) ){
													foreach($cal_years[$key] as $cal_events_key=>$cal_events){
														
														/*Event's Date*/
														if( !empty($cal_events->sched_date_end) ){
															$events_date = date('M j',strtotime($cal_events->sched_date_start)) .' - '.  date('M j',strtotime($cal_events->sched_date_end));
														}else{
															$events_date = date('M j',strtotime($cal_events->sched_date_start));
														}
														
														/*Event Link*/
														$permalink = get_permalink($cal_events->ID);
														if($cal_events->post_type=='inugget'){ $permalink = CFS()->get('html_file',$val->ID); }
														if($cal_events->post_type=='webinar'){ $permalink = CFS()->get('webinar_html_file',$val->ID); }
														if($cal_events->post_type=='friday-forum'){ $permalink = CFS()->get('friday_forum_html_file',$val->ID); }
														
														$data .= '<tr class="'. strtolower(preg_replace('/[^\da-z]/i', '-', $cal_events->sched_location)) . ' '. $cal_events->post_type .'">';
														$data .= 	'<td class="event-date" style="width:25%;">'. $events_date .'</td>';
														$data .= 	'<td class="event-title"><a href="'. $permalink .'" target="_blank">'. $cal_events->post_title .'</a></td>';
														$data .= 	'<td class="event-loc" style="width:25%;">'. $cal_events->sched_location .'</td>';
														$data .= '</tr>';
													}
												}else{
													$data .= '<tr><td>No class / event scheduled for this month</td></tr>';
												}
									$data .= 	'</table>';
									$data .= 	'</div>';
									$data .= '</div>';
								}
				$data .= 	'</div>';
				$data .=  '</div>';
			}
		$data .= '</div>';
		$data .= '</div>';
		return $data;
	}
	
	/***************************************************************************************
		Get course category info
	***************************************************************************************/
	function get_cat_info($id){
		global $wpdb;
		$id = (int) $id;
		return $wpdb->get_row("SELECT * FROM ap_terms WHERE term_id='{$id}' LIMIT 1", OBJECT);
	}

	/***************************************************************************************
		Get all available courses
	***************************************************************************************/
	function get_all_course(){
		global $wpdb;
		$row	= $wpdb->get_results("SELECT post_title FROM ap_posts WHERE post_type='project' AND post_status='publish' ORDER BY post_title ASC", OBJECT);
		$data	= array();
		foreach($row as $key=>$val){
			$data[] = $val->post_title;
		}
		return json_encode($data);
	}


	/***************************************************************************************
		Get all available Location
	***************************************************************************************/
	function getAllCourseLocation(){
		global $wpdb;
		$rows = $wpdb->get_results("SELECT meta_key, meta_value AS location, count(meta_value) as total_count FROM ap_postmeta WHERE meta_key='sched_location' AND meta_value!='' GROUP BY meta_value", OBJECT);
		return $rows;
	}


	/***************************************************************************************
		Course Mega Menu
	***************************************************************************************/
	function get_course_megamenu(){
		$data = '';
		$data .= '<ul class="sub-menu">';
			foreach(get_course_by_category(999) as $key=>$val){
				$data .= '<li class="menu-item menu-item-has-children"><a href="'. get_course_category_url($key) .'">'. $val['name'] .'</a>';
					if(count($val['item'])){
						$data .= '<ul class="sub-menu">';
							foreach($val['item'] as $k_item=>$v_item){
								$data .= '<li class="menu-item"><a href="'. get_permalink($v_item->ID) .'">'. $v_item->post_title .'</a></li>';
							}
						$data .= '</ul>';
					}
				$data .= '</li>';
			}
		$data .= '</ul>';
		return $data;
	}
	
	function get_course_megamenu2(){
		$domain_filter = array();
		$data = '';
		foreach(get_course_by_category(999) as $key=>$val){
			$domain_filter[$val['cat_parent']][$key] = $val;
		}
		$data .= '<div class="mega-menu-dropdown"><ul>';
			foreach($domain_filter as $k_domain=>$v_domain){
				$data .= '<li class="domain-'. $k_domain .'"><div class="domain-name">'. get_cat_info($k_domain)->name .'</div>';
					if( count($v_domain) ){
						$data .= '<ul>';
							foreach($v_domain as $k_cat=>$v_cat){
								$data .= '<li><a href="'. get_course_category_url($k_cat) .'">'. get_cat_info($k_cat)->name .'&nbsp;&nbsp;<span class="course_count">('. count($v_cat['item']) .')</span></a>';
									if( count($v_cat['item']) ){
										$data .= '<ul>';
											foreach($v_cat['item'] as $k_course=>$v_course){
												$data .= '<li><a href="'. get_permalink($v_course->ID) .'">'. addslashes($v_course->post_title) .'</a></li>';
											}
										$data .= '</ul>';
									}
								$data .= '</li>';
							}
							$data .= '<li class="game-based-learning"><a href="/learning-on-demand/game-based-learning/">Game Based Learning</a></li>';
						$data .= '</ul>';
					}
				$data .= '</li>';
			}
		$data .= '</ul"></div>';
		return $data;
	}

	
	/***************************************************************************************
		CUSTOM POST META
	***************************************************************************************/
	function custom_post_meta( $postid=null ){
		
		$post_categories = array();
		foreach(get_the_category($postid) as $cat){
			if($cat->term_id != 33 ){
				$post_categories[] = '<a rel="category tag" href="'. get_category_link($cat->term_id) .'">'. $cat->name .'</a>';
			}
		}
		
		echo '<p class="post-meta">';
		echo 	'<span class="author vcard">';
					the_author_posts_link();
		echo 	'</span>';
		echo 	' | <span class="published">'. get_the_date() .'</span>';
				if(count($post_categories)){
					echo 	' | ' . implode(',', $post_categories);
				}
		echo '</p>';
	}
	
	
	/***************************************************************************************
		DD Social Buttons
	***************************************************************************************/
	function custom_dd_social_buttons( $postid=null ){
		echo '<div class="dd_custom_float_bar">';
			dd_twitter_generate('Normal','apex_global');
			dd_fbshare_generate('Normal');
			dd_linkedin_generate('Normal');
			dd_fblike_generate('Like Box Count');
			dd_google1_generate('Normal');
		echo '</div>';
	}
	
	/***************************************************************************************
		CUSTOM PAGINATION
	***************************************************************************************/
	function custom_pagination($query_str, $item_per_page=10, $pagi_url= 'index.php', $num_perpage=10){
		global $wpdb;
		$item_per_page	= (int) $item_per_page;
		$total_rows		= count( $wpdb->get_results($query_str, OBJECT) );
		$total_pages	= ceil($total_rows / $item_per_page);
		
		if($num_perpage > $total_pages){
			$num_perpage = $total_pages;
		}
		
		$current_page	= intval($_GET['current_page']);
		if($current_page < 1){
			$current_page = 1;
		}elseif($current_page > $total_pages){
			$current_page = $total_pages;
		}
		
		$q_start	= ($current_page - 1) * $item_per_page;
		$q_limit	= $item_per_page;
		$item_list	= $wpdb->get_results($query_str . " LIMIT {$q_start},{$q_limit}", OBJECT);
		
		if($total_rows <= 0 || $total_rows <= $item_per_page){
			$display = "";	
		}else{
			$display = custom_pagination_display($pagi_url, $current_page, $num_perpage, $total_pages);
		}
		
		return array('items'=>$item_list, 'display'=>$display);
	} /*end of custom_pagination() */

	function custom_pagination_display($pagi_url, $current_page, $num_perpage, $total_pages){
	
		if( strpos($pagi_url, '?') === FALSE ){
			$pagi_url .= '?';
		}else{
			$pagi_url .= '&';
		}
	
		$display_pages = "<ul class=\"custom_pagination\">";
			/* START */
			if($current_page <= 1){
				$display_pages .= '<li class="pagination-start"><span class="pagenav"><i class="fa fa-angle-double-left"></i></span></li>';
			}else{
				$display_pages .= '<li class="pagination-start"><a href="'. $pagi_url .'current_page=1" class="pagenav"><i class="fa fa-angle-double-left"></i></a></li>';
			}

			/* PREV */
			if($current_page <= 1){
				$display_pages .= '<li class="pagination-prev"><span class="pagenav"><i class="fa fa-angle-left"></i></span></li>';
			}else{
				$display_pages .= '<li class="pagination-prev"><a href="'. $pagi_url .'current_page='. ($current_page-1) .'" class="pagenav"><i class="fa fa-angle-left"></i></a></li>';
			}
			
			/* PAGINATION NUMBERS */		
			if($current_page <= $num_perpage){		
				for($x = 1; $x <= $num_perpage ; $x++){
					if($x == $current_page){
						$display_pages .= '<li class="pagination-num current-page"><span class="pagenav">' . $x . '</span></li>';
					}else{
						$display_pages .= '<li class="pagination-num"><a href="' . $pagi_url . 'current_page=' . $x . '" class="pagenav">' . $x . '</a></li>';
					}
				}
			}else{
				for($x=($current_page - $num_perpage)+1; $x<=$current_page; $x++){
					if($x == $current_page){
						$display_pages .= '<li class="pagination-num current-page"><span class="pagenav">' . $x . '</span></li>';
					}else{
						$display_pages .= '<li class="pagination-num"><a href="' . $pagi_url . 'current_page=' . $x . '" class="pagenav">' . $x . '</a></li>';
					}
				}
			}
			/* END OF PAGINATION NUMBERS */
			
			/* NEXT */
			if($current_page >= $total_pages){
				$display_pages .= '<li class="pagination-next"><span class="pagenav"><i class="fa fa-angle-right"></i></span></li>';
			}else{
				$display_pages .= '<li class="pagination-next"><a href="'. $pagi_url .'current_page='. ($current_page+1) .'" class="pagenav"><i class="fa fa-angle-right"></i></a></li>';
			}
					
			/* END */
			if($current_page >= $total_pages){
				$display_pages .= '<li class="pagination-end"><span class="pagenav"><i class="fa fa-angle-double-right"></i></span></li>';
			}else{
				$display_pages .= '<li class="pagination-end"><a href="'. $pagi_url .'current_page='. $total_pages .'" class="pagenav"><i class="fa fa-angle-double-right"></i></a></li>';
			}
		$display_pages .= "</ul>";
		
		return $display_pages;
	} /* end of custom_pagination_display() */
	
	