<?php
require_once('admin/ct_max_meta.php');

add_action('init', 'vq_apex_custom_posts');

add_action('init', 'vq_apex_custom_taxonomies');

add_shortcode('vq_short_banner', 'vq_render_short_banner');

add_action('add_meta_boxes', 'vq_add_custom_meta_boxes', 10, 2);

add_filter('wp_nav_menu_items', 'vq_add_lms_navigation', 10, 2);


function vq_apex_custom_posts() {
	$labels = array(
		'name'               => __( 'LMS Courses'),
		'singular_name'      => __( 'LMS Course'),
		'menu_name'          => __( 'LMS Courses'),
		'name_admin_bar'     => __( 'LMS Course'),
		'add_new'            => __( 'Add New', 'course'),
		'add_new_item'       => __( 'Add New LMS Course'),
		'new_item'           => __( 'New LMS Course'),
		'edit_item'          => __( 'Edit LMS Course'),
		'view_item'          => __( 'View LMS Course'),
		'all_items'          => __( 'All LMS Courses'),
		'search_items'       => __( 'Search LMS Courses'),
		'parent_item_colon'  => __( 'Parent LMS Courses:'),
		'not_found'          => __( 'No lms courses found.'),
		'not_found_in_trash' => __( 'No lms courses found in Trash.')
	);

	$args = array(
		'labels'             => $labels,
		'description'        => __( 'Description.'),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'vq_course' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail')
	);

	register_post_type( 'vq_course', $args );
}

function vq_apex_custom_taxonomies() {
	$labels = array(
		'name'          =>  'LMS Category',
		'add_new_item'  =>  'Add New LMS Category',
		'new_item_name' =>  'New LMS Category'
	);

	register_taxonomy(
		'vq_course_taxonomy',
		'vq_course',
		array(
			$labels,
			'show_ui'       =>  true,
			'show_tagcloud' => false,
			'hierarchical' => true
		)
	);
}

function vq_render_short_banner($attr) {
	$bgColor = isset($attr['bgClr']) ? attr['bgClr'] : "#000";
	$btnBg = isset($attr['btnBg']) ? attr['btnBg'] : "#00f";
	$txt = isset($attr['txt']) ? attr['txt'] : "Heading";
	$txtClr = isset($attr['txtClr']) ? attr['txtClr'] : "#fff";
	$btnClr = isset($attr['btnClr']) ? attr['btnClr'] : "#fff";
	$btnLink = isset($attr['btnLink']) ? $attr['btnLink'] : 'https://google.com';
	$btnTxt = isset($attr['btnTxt']) ? $attr['btnTxt'] : 'Click Here';

	$a = shortcode_atts( array(
		'foo' => 'something',
		'bar' => 'something else',
	), $attr );

}

function vq_add_custom_meta_boxes() {
	add_meta_box(
		'vq_short_banner_shortcode_metabox',
		'Short Banner Shortcode',
		'vq_render_short_banner_shortcode_metabox',
		'vq_course',
		'side',
		'high'
	);
}

function vq_render_short_banner_shortcode_metabox() {
	echo '[vq_short_banner bgClr="" btnBg="" txt="" txtClr="" btnClr="" btnLink="" btnTxt=""]';
}

function vq_add_lms_navigation($items, $args) {
	$items .= '<li id="menu-item-786" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-786"><a href="">E-Learning</a></li>';
	return $items;
}