<?php
get_header();

$page = get_page_by_path('lms');
$course_categories = get_terms( array(
	'taxonomy' => 'vq_course_taxonomy',
	'parent' => 0,
	'hide_empty' => false,
));

?>
    <div class="bootstrap-iso">
        <div class="e-learning-banner" style="position: relative; background-image: url(<?php echo get_the_post_thumbnail_url($page); ?>)">

            <a href="https://www.learn.apexgloballearning.com/" class="" style="position: absolute; top: -1%; right: 9%;">
                <img style="width: 80%;" src="<?php echo plugin_dir_url(__FILE__); ?>imgaes/E-learning-login.png" alt="">
            </a>
            <div class="container">
                <div class="row">
                    <div class="e-learning-heading">
                        <h2><?php echo $page->post_title ?></h2>
                        <h3><?php echo $page->post_content ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="learning-profile-bg">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="e-learning-heading">
                            <h4><?php echo $page->post_excerpt  ?></h4>
                        </div>
                    </div>
                    <?php foreach ($course_categories as $category){ ?>
                    <div class="col-sm-3">
                        <div class="learning-profile-box">
                            <div class="e-learning-course-1" style="background-image: url(<?php echo wp_get_attachment_url(get_term_meta($category->term_id, 'vq_course_taxonomy-image-id', true)) ?>)">
                                <div class="e-learning-heading">
                                    <h5><?php echo $category->name  ?></h5>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="e-learning-heading descrip">
                                    <p><?php echo substr($category->description, 0,150) . ' ...'  ;  ?></p>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="text-center">
                                    <a href="<?php echo get_permalink(get_page_by_path('lms-courses')) . $category->slug ?>" class="learn-button">Learn More</a>
                                </div>
                            </div>
                            <div class="clear"></div>
                        </div>
                    </div>
	                <?php } ?>
                </div>
            </div>
        </div>

	    <?php echo  do_shortcode('[vq_short_banner 
	        txtClr="#fff" 
	        btnClr="#fff" 
	        bgClr="#f89f18" 
	        btnBg="#2898c4" 
	        btnLink="lms-pricing"
	        btnTxt="Download Full List Of Courses" 
	        txt="Not sure which course to take?"]'); ?>

        <?php $ad = get_page_by_path('learning-management');
        echo do_shortcode("[vq_course_banner id=\"{$ad->ID}\"]") ?>
    </div>
<?php
get_footer();
?>