<?php

	/*********************************************************************************
		Change the DIVI project slug
	*********************************************************************************/
	function custom_post_name() {
		return array(
			'feeds' => true,
			'slug' => 'course',
			'with_front' => false,
		);
	}
	add_filter( 'et_project_posttype_rewrite_args', 'custom_post_name' );
	

	/*********************************************************************************
		This code anbles Shortcodes in WordPress Text Widget
	*********************************************************************************/
	add_filter('widget_text', 'do_shortcode');
	
	
	/*********************************************************************************
		Filter the WP Search Results to only show post and page post_type
	*********************************************************************************/
	function searchfilter($query) {
		if( ! is_admin() && $query->is_main_query() && $query->is_search) {
			if( $query->query_vars['post_type'] != 'inugget' AND $query->query_vars['post_type'] != 'webinar' AND $query->query_vars['post_type'] != 'friday-forum' AND $query->query_vars['post_type'] != 'post'){
				$query->set('post_type',array('post','page','project'));
			}
		}
		return $query;
	}
	add_filter('pre_get_posts','searchfilter');
	
	
	/*********************************************************************************
		Separate media categories from post categories
		Use a custom category called 'category_media' for the categories in the media library
	*********************************************************************************/
	add_filter( 'wpmediacategory_taxonomy', function(){ return 'category_media'; } );
	
	
	/*********************************************************************************
		Disable annoying scripts in` so we can re-add them in
	*********************************************************************************/	
	//add_action( 'wp_print_scripts', 'my_deregister_javascript', 100 );
	function my_deregister_javascript() {
		wp_deregister_script('jquery-core');
		wp_deregister_script('jquery-migrate');
		wp_deregister_script('wpdm-bootstrap');
		wp_deregister_script('frontjs');
		wp_deregister_script('jquery-choosen');
	}
	
	/*********************************************************************************
		Add Custom Style and Scripts
	*********************************************************************************/	
	add_action( 'wp_enqueue_scripts', 'custom_load_custom_style_sheet' );
	function custom_load_custom_style_sheet() {
		/* $ver = time(); */
		$ver = '2.9';
		
		/*Scripts from the header that we-deregister then re-add so we can place it in the footer*/
		//wp_enqueue_script( 'new-jquery-core', '/wp-includes/js/jquery/jquery.js', array(), $ver, true);
		//wp_enqueue_script( 'new-jquery-migrate', '/wp-includes/js/jquery/jquery-migrate.min.js', array(), $ver, true);
		//wp_enqueue_script( 'new-wpdm-bootstrap', '/wp-content/plugins/download-manager/assets/bootstrap/js/bootstrap.min.js', array(), $ver, true);
		//wp_enqueue_script( 'new-frontjs', '/wp-content/plugins/download-manager/assets/js/front.js', array(), $ver, true);
		//wp_enqueue_script( 'new-jquery-choosen', '/wp-content/plugins/download-manager/assets/js/chosen.jquery.min.js', array(), $ver, true);

		wp_enqueue_script( 'jquery-ui-script', get_bloginfo( 'stylesheet_directory' ) . '/js/jquery-ui.js', array(), '1.0.0', true);
		wp_enqueue_script( 'fancybox-script', get_bloginfo( 'stylesheet_directory' ) . '/js/jquery.fancybox.js', array(), '1.0.0', true );
		wp_enqueue_script( 'sticky-script', get_bloginfo( 'stylesheet_directory' ) . '/js/jquery.sticky.js', array(), '1.0.0', true );
		wp_enqueue_script( 'bxslider-script', get_bloginfo( 'stylesheet_directory' ) . '/js/jquery.bxslider.min.js', array(), $ver, true );
		wp_enqueue_script( 'grayscale-script', get_bloginfo( 'stylesheet_directory' ) . '/js/grayscale.js', array(), $ver, true );
		wp_enqueue_script( 'grayscale-func-script', get_bloginfo( 'stylesheet_directory' ) . '/js/grayscale_function.js', array(), $ver, true );
		wp_enqueue_script( 'jquery-cookie-script', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.js', array(), $ver, true );
		wp_enqueue_script( 'custom-script', get_bloginfo( 'stylesheet_directory' ) . '/js/custom-script.js', array(), time(), true );
		
		wp_enqueue_style( 'jquery-ui-stylesheet', get_bloginfo( 'stylesheet_directory' ) . '/css/jquery-ui.min.css', array(), $ver );
		wp_enqueue_style( 'fancybox-stylesheet', get_bloginfo( 'stylesheet_directory' ) . '/css/jquery.fancybox.css', array(), $ver );
		wp_enqueue_style( 'bxslider-stylesheet', get_bloginfo( 'stylesheet_directory' ) . '/css/jquery.bxslider.css', array(), $ver );
		wp_enqueue_style( 'fontawesome-stylesheet', get_bloginfo( 'stylesheet_directory' ) . '/css/font-awesome.min.css', array(), $ver );
		wp_enqueue_style( 'custom-stylesheet', get_bloginfo( 'stylesheet_directory' ) . '/css/template.css', array(), $ver );
	}
	
	
	/*********************************************************************************
		Short-code for Homepage Instant Search
	*********************************************************************************/
	function instant_search_form($atts, $contents=NULL){
		//extract(shortcode_atts(array( 'post'=>0, 'delay'=>23), $atts));
		
		$data  = '<script type="text/javascript" defer>';
		$data .= 	'jQuery(function(){';
		$data .= 		'var course_list = ' . get_all_course() .';';
		$data .= 		'jQuery(".homepage-instant-search-form .keyword").autocomplete({source:course_list});';
		$data .= 	'});';
		$data .= '</script>';
		
		$data .= '<form action="/courses" method="get" class="homepage-instant-search-form">';
		$data .= 	'<input type="text" name="keyword" class="keyword" placeholder="Search from over 300 courses"/>';
		$data .= 	'<button type="submit" class="search-btn et_pb_promo_button et_pb_button">Search</button>';
		$data .= 	'<a class="calendar-btn no_smooth_scroll fancybox" href="#calendar-module">&nbsp;</a>';
		/*$data .= 	'<a class="calendar-btn no_smooth_scroll popmake-5718" href="#calendar-module">&nbsp;</a>';*/
		$data .= 	'<div class="clearfix"></div>';
		$data .= '</form>';
		$data .= '<div class="clearfix"></div>';

		return $data;
	}
	add_shortcode('instant_search_form', 'instant_search_form');
		

	/*********************************************************************************
		Course Page - Custom Search
	*********************************************************************************/
	add_action( 'wp_ajax_course_search', 'custom_search_course' );
	add_action( 'wp_ajax_nopriv_course_search', 'custom_search_course' );
	function custom_search_course() {
		global $wpdb;
		$keyword	= '%'. trim(strtolower($_POST['keyword'])) .'%';
		
		$query_str	= "
			SELECT count(postmeta.post_id) post_count, post.*, postmeta.* FROM ap_posts AS post LEFT JOIN ap_postmeta as postmeta ON post.ID=postmeta.post_id
			WHERE post.post_status='publish'
			AND post.post_type='project' 
			AND (LOWER(postmeta.meta_value) LIKE '%s' OR LOWER(post.post_title) LIKE '%s' OR LOWER(post.post_content) LIKE '%s')
			GROUP BY postmeta.post_id
			ORDER BY post.post_title ASC
		";
		
		$query_str	= $wpdb->prepare($query_str, $keyword, $keyword, $keyword);
		$pagination = custom_pagination($query_str, 9, '/wp-admin/admin-ajax.php');
		$data = '';
		if(count($pagination['items']) <= 0){
			$data = '<h3 class="no-item-found">No item found</h3>';
		}else{
			$data .='<div class="course-list-wrapper">';
				foreach($pagination['items'] as $key=>$val){
					
					$get_course_domain	= get_course_domain($val->ID);
					$course_type		= CFS()->get('course_type', $val->ID);
					$course_type		= ( !empty($course_type) ) ? reset($course_type) : '';
					$course_days		= CFS()->get('course_days', $val->ID);
					
					
					$data	.= '<div class="course-item">
									<a href="'. get_permalink($val->ID) .'">
										<div class="image-wrapper">'. get_course_thumb($val->ID) .'</div>
										<div class="content-wrapper">
											<div class="course-title">'. ((strlen($val->post_title) > 40) ? substr($val->post_title, 0, 37) . '...' : $val->post_title) .'</div>
											<div class="course-type">'. $course_type .'</div>
											<div class="course-days">'. $course_days .'</div>
										</div>
									</a>
									<a href="'. get_permalink($val->ID) .'" class="course-item-hover"></a>
								</div>';
				}
			$data .='<div class="clearfix"></div>';
			$data .='</div>';
			$data .='<div class="course-pagination">'. $pagination['display'] .'<div class="clearfix"></div></div>';
		}
		echo $data;
		exit();
	}

	
	/*********************************************************************************
		Course Page - Custom Search
	*********************************************************************************/
	add_action( 'wp_ajax_custom_course_search', 'custom_search_course_v2' );
	add_action( 'wp_ajax_nopriv_custom_course_search', 'custom_search_course_v2' );
	function custom_search_course_v2(){
		$get_custom_course	= get_custom_course( $_POST['keyword'] );
		$data = '';
		if( count($get_custom_course) == 0 ){
			$data = '<h3 class="no-item-found">No item found</h3>';
		}else{
			$data .= '<div class="course-category-nav">';
			$data .= '<ul>';
				foreach($get_custom_course as $key=>$val){					
					$data .= 		'<li class="cat_parent_'. $val->cat_parent_id .'">';
					$data .= 			'<span>'. $val->post_title .'</span>';
					$data .= 			'<a href="#inquire-now-to-custom-courses" class="inquire-btn fancybox no_smooth_scroll" data-course="'. $val->post_title .'">Inquire Now</a>';
					$data .= 		'</li>';
				}
			$data .= '</ul>';
			$data .= '</div>';
		}
		echo $data;
		exit();
	}
	
	
	
	/*********************************************************************************
		Utitity - Get all Courses
	*********************************************************************************/
	add_action( 'wp_ajax_ajax_courses', 'get_ajax_courses' );
	add_action( 'wp_ajax_nopriv_ajax_courses', 'get_ajax_courses' );
	function get_ajax_courses(){
		echo get_all_course();
		exit();
	}
	
	
	/*********************************************************************************
		Get Latest Post
	*********************************************************************************/
	function custom_wp_latest_post($atts, $contents=NULL){
		extract(shortcode_atts(array(
			'post'	=> 4,
			'post_type'	=> 'post',
			'max_title'	=> 50
		), $atts));

		$args = array('numberposts' => $post, 'orderby' => 'post_date', 'order' => 'DESC', 'post_type' => $post_type, 'post_status' => 'publish');
		$the_query = wp_get_recent_posts( $args, ARRAY_A );					
		$data = '<div class="wp_latest_post">';
			foreach($the_query as $item){
				
				$permalink = get_permalink($item['ID']);
				if($post_type=='inugget'){ $permalink = CFS()->get('html_file',$item['ID']); }
				if($post_type=='webinar'){ $permalink = CFS()->get('webinar_html_file',$item['ID']); }
				if($post_type=='friday-forum'){ $permalink = CFS()->get('friday_forum_html_file',$item['ID']); }
				
				$data .= '<div class="et_pb_column et_pb_column_1_4">';
				$data .= 	'<div class="et_pb_blurb et_pb_module et_pb_bg_layout_light et_pb_text_align_center  et_pb_blurb_8 et_pb_blurb_position_top">';
				$data .= 		'<div class="et_pb_blurb_content">';
				$data .= 			'<div class="et_pb_main_blurb_image"><a href="'. $permalink .'">' . get_post_thumb($item['ID']) . '</a></div>';
				$data .= 			'<div class="et_pb_blurb_container">';
				$data .= 				'<h5><a href="'. $permalink .'">'. ( count($item['post_title']>$max_title)? substr($item['post_title'],0,($max_title-3)).'...' : $item['post_title'] ) .'</a></h5>';
				$data .= 				'<p>'. date( "F j, Y", strtotime($item['post_date']) ) .'</p>';
				$data .= 			'</div>';
				$data .= 		'</div>';
				$data .= 	'</div>';
				$data .= '</div>';
			}
			$data .= '</div>';
		return $data;
	}
	add_shortcode('wp_latest_post', 'custom_wp_latest_post');
	
	
	/*********************************************************************************
		Get All Promos [get_promo_list] 
	*********************************************************************************/
	function get_promo_list($atts, $contents=NULL){
		//extract(shortcode_atts(array( 'post'=>0, 'delay'=>23), $atts));
		$promo_list = CFS()->get('promos_list');
		$data = '<div class="promo_list">';
			if(count($promo_list)){
				foreach ($promo_list as $field) {
					if( empty($field['promo_expiration']) || $field['promo_expiration'] > date("Y-m-d H:i:s") ){
						$data .= '<div class="promo_item">';
						$data .= 	'<a data-promo="'. $field['promo_code'] .'" class="fancybox no_smooth_scroll enroll-now-promo-btn" href="#enroll-now-form-promo"><img alt="promo-banner" class="promo-'.$field['promo_code'].'" src="'. $field['promo_image'] .'"></a>';
						$data .= '</div>';
					}
				}
			}
		$data .= '</div>';
		$data .= '<div class="clearfix"></div>';
		return $data;
	}
	add_shortcode('get_promo_list', 'get_promo_list');
	
	
	
	/*********************************************************************************
		Get All Promos for the sidebar [get_promo_list_sidebar] 
	*********************************************************************************/
	function get_promo_list_sidebar($atts, $contents=NULL){
		//extract(shortcode_atts(array( 'post'=>0, 'delay'=>23), $atts));
		$promo_list = CFS()->get('promos_list',293);
			if(count($promo_list)){
				foreach ($promo_list as $field) {
					if( empty($field['promo_expiration']) || $field['promo_expiration'] > date("Y-m-d H:i:s") ){
						if($field['promo_use_as_banner']){
							$data .= '<div class="promo-banner-section">';
							$data .= 	'<a data-promo="'. $field['promo_code'] .'" class="fancybox no_smooth_scroll enroll-now-promo-btn" href="#enroll-now-form-promo"><img alt="promo-banner" class="promo-'.$field['promo_code'].'" src="'. $field['promo_image'] .'"></a>';
							$data .= '</div>';
						}
					}
				}
			}
		$data .= '<div class="clearfix"></div>';
		return $data;
	}
	add_shortcode('get_promo_list_sidebar', 'get_promo_list_sidebar');
	
	
	
	/*********************************************************************************
		Get WP download Manager download-link
	*********************************************************************************/
	function get_wpdmdl_link($atts, $contents=NULL){
		extract(shortcode_atts(array('post_id'=>0), $atts));
		return get_bloginfo('url') . "?wpdmdl={$post_id}";
	}
	add_shortcode('get_wpdmdl_link', 'get_wpdmdl_link');



	/*********************************************************************************
		BreadCrumbs
	*********************************************************************************/
	function wp_simple_breadcrumb($atts, $contents=NULL){
		if(function_exists(simple_breadcrumb)) {
			return simple_breadcrumb();
		}else{
			return "Breadcrumb Plugin Missing";
		}
	}
	add_shortcode('wp_simple_breadcrumb', 'wp_simple_breadcrumb');


	/*********************************************************************************
		Calenndar Shortcodes
	*********************************************************************************/
	function wp_display_course_calendar($atts, $contents=NULL){
		return display_course_calendar();
	}
	add_shortcode('wp_display_course_calendar', 'wp_display_course_calendar');
	
	
	
	/*********************************************************************************
		Upcoming Event
	*********************************************************************************/
	function apex_upcoming_events($atts, $contents=NULL){
		extract(shortcode_atts(array( 'post'=>5, 'post_type'=>'post'), $atts));
		global $wpdb;
		$query_str = "SELECT * FROM ap_posts WHERE post_type='{$post_type}' AND post_status='future' ORDER BY post_date ASC LIMIT {$post}";
		$total_rows	= $wpdb->get_results($query_str, OBJECT);
		
		if($total_rows){
			$data .= '<ul class="upcoming_event">';
			foreach($total_rows as $key=>$val){
				
				$permalink = get_permalink($val->ID);
				if($post_type=='inugget'){ $permalink = CFS()->get('html_file',$val->ID); }
				if($post_type=='webinar'){ $permalink = CFS()->get('webinar_html_file',$val->ID); }
				if($post_type=='friday-forum'){ $permalink = CFS()->get('friday_forum_html_file',$val->ID); }
				
				$data .= '<li>';
				$data .= 	'<a href="'. $permalink .'">'. ((strlen($val->post_title) > 65) ? substr($val->post_title,0,62).'...' : $val->post_title) .'</a>';
				$data .= 	'<div class="post_date">'. date("F j, Y", strtotime($val->post_date)) .'</div>';
				$data .= '</li>';
			}
			$data .= '</ul>';
		}else{
			$data = '<ul><li>No Upcoming Event</li></ul>';
		}
		
		return $data;
	}
	add_shortcode('apex_upcoming_events', 'apex_upcoming_events');
	
	
	
	/***************************************************************************************
		Home Testimonials
	***************************************************************************************/
	function home_testimonials( $postid=null ){
		$promo_list = CFS()->get('slide-logo',2);
		if(count($promo_list)){
			$data .= '<div class="customer-custom-slider">';
				foreach($promo_list as $field){
					$data .= '<div class="customer-slider-section">';
						$data .= ' <ul class="client-logos">
									 <li class="column-1-5"><img src="'. $field['slider_logo_1'] .'" alt="slide logo" /></li>
									 <li class="column-1-5"><img src="'. $field['slider_logo_2'] .'" alt="slide logo" /></li>
									 <li class="column-1-5"><img src="'. $field['slider_logo_3'] .'" alt="slide logo" /></li>
									 <li class="column-1-5"><img src="'. $field['slider_logo_4'] .'" alt="slide logo" /></li>
									 <li class="column-1-5"><img src="'. $field['slider_logo_5'] .'" alt="slide logo" /></li>
								  </ul>';
						$data .= '<div class="clearfix"></div>';
						$data .= (empty($field['slider_testi_text'])) ? '' : '<div class="testi_text">'. $field['slider_testi_text'] .'</div>';
						$data .= (empty($field['slider_testi_position'])) ? '' : '<span class="testi_post">'. $field['slider_testi_position']  .'</span>';
						$data .= (empty($field['slider_testi_comp'])) ? '' : '<span class="testi_comp">'. $field['slider_testi_comp']  .'</span>';
					$data .= '</div>';
				}
			$data .= '</div>';
		}
		
		return $data;
	}
	add_shortcode('home_testimonials', 'home_testimonials');
	
	
	
	
	/*********************************************************************************
		Related Course
	*********************************************************************************/
	function apex_related_course($atts, $contents=NULL){
		$related_course = CFS()->get('related_course_list');
			if(count($related_course)){
				foreach ($related_course as $field) {
					$data .= '<div class="related-course-section">';
					$data .= 	'<div class="related-course-banner"><a href="'. $field['related_course_link'] .'" target="_blank"><img src="'. $field['related_course_img'] .'" alt="" /></a></div>';
					$data .= '</div>';
				}
			}
		$data .= '<div class="clearfix"></div>';
		return $data;
	}
	add_shortcode('apex_related_course', 'apex_related_course');
	
	
	/*********************************************************************************
		Code Share
	*********************************************************************************/
	function custom_code_share($atts, $contents=NULL){
		$infographic_img	= CFS()->get('infographic_img');
		$infographic_link	= CFS()->get('infographic_link');
		$infographic_text	= CFS()->get('infographic_text');
		$infographic_title	= CFS()->get('infographic_title');
		$data				= '';
		
		if( !empty($infographic_img) ){
			$data = '<div class="code_share">
						<div class="introtext">'. $infographic_text .'</div>
						<textarea><p style="text-align:center;"><a style="max-width:100%;" href="'. $infographic_link .'"><img src="'. $infographic_img .'" alt="'. $infographic_title .'" title="'. $infographic_title .'"/></a><br /><br />via: <a href="'. get_site_url() .'">APEX Global</a></p></textarea>
					</div>';
		}
		return $data;
	}
	add_shortcode('code_share', 'custom_code_share');
	
	
	/*********************************************************************************
		Eliminate Render-Blocking for JavaScript (As for Google PageSpeed Insights)
	*********************************************************************************/
	function add_async_attribute($tag, $handle) {
		//if ( 'my-js-handle' !== $handle )
		if( is_admin() ) 
			return $tag;
		//if( 'jquery-core' == $handle || 'jquery-ui-script' == $handle || 'custom-script' == $handle)
		if( 'jquery-core' == $handle || 'jquery-migrate' == $handle || 'wpdm-bootstrap' == $handle || 'frontjs' == $handle || 'jquery-choosen' == $handle){
			return str_replace( ' src', ' async src', $tag );
		}else{
			return $tag;
		}
	}
	//add_filter('script_loader_tag', 'add_async_attribute', 10, 2);
	
	
	/*********************************************************************************
		Eliminate Render-Blocking for CSS (As for Google PageSpeed Insights)
		https://developers.google.com/speed/docs/insights/OptimizeCSSDelivery#example
	*********************************************************************************/
		/*
		Save all CSS files in SESSION instead of echoing directly to the page
		unset($_SESSION['wp_enqueue_style']);
		function sample_style_change($tag, $handle) {
			if( is_admin() ) return $tag;
			$_SESSION['wp_enqueue_style'][] = $tag;
			return false;
		}
		add_filter('style_loader_tag', 'sample_style_change', 10, 2);
		*/
	
		/*Loop all saved CSS stylesheets. 
		Go to header.php in your theme then ECHO display_wp_enqueue_style() directly below the <BODY>
		Dont forget to ECHO google's recommended script for render-blocking */
		function display_wp_enqueue_style(){
			$data .= ' <noscript id="deferred-styles">';
				foreach($_SESSION['wp_enqueue_style'] as $k=>$wp_enqueue_css){
					$data .= $wp_enqueue_css;
				}
			$data .= '</noscript>';
			return $data;
		}
	