<?php


add_action('save_post_vq_course', 'vq_handle_course_post');
add_action('save_post_vq_lms_orders', 'vq_handle_order_post');
add_action('manage_vq_lms_orders_posts_custom_column', 'vq_render_order_columns_data', 10, 2);
add_filter('manage_vq_lms_orders_posts_columns', 'vq_render_order_columns');

function vq_handle_course_post() {
	if(isset($_POST['course_attachment_id'])) {
		$attachment_id = $_POST['course_attachment_id'];
		$attachment_url = $_POST['course_attachment_url'];
		$listingContent = $_POST['listing_content'];
		update_post_meta(get_the_ID(), 'course_attachment_id', $attachment_id);
		update_post_meta(get_the_ID(), 'course_attachment_url', $attachment_url);
		update_post_meta(get_the_ID(), 'listing_content', $listingContent);

	}

	if(isset($_POST['course_fee'])) {
		update_post_meta(get_the_ID(), 'course_fee', $_POST['course_fee']);
	}
}

function vq_handle_order_post() {
	$price = isset($_POST['price']) ? $_POST['price'] : '';
	$payment_status = isset($_POST['payment_status']) ? $_POST['payment_status'] : '';

	update_post_meta(get_the_ID(), 'total_amount', $price);
	update_post_meta(get_the_ID(), 'payment_status', $payment_status);

}

function vq_render_order_columns($columns) {

	$new_columns = array(
		'price' =>  'Cost',
		'payment_status' =>  'Payment Status',
	);

	return array_merge($columns, $new_columns);
}

function vq_render_order_columns_data($column , $post_id) {
	echo get_post_meta($post_id, $column, true);
}