<?php
/*
Template Name: All Course
*/
get_header();
$is_page_builder_used = et_pb_is_pagebuilder_used( get_the_ID() ); 
?>

<?php if( isset($_GET['keyword']) ){?>
	<script type="text/javascript">	
		//Check if the Keword is set, then apply the search based on the keyword
		jQuery(function(){
			custom_course_search('<?=$_GET['keyword'];?>', '/wp-admin/admin-ajax.php');
		});
	</script>
<?php }?>

<div id="main-content">

	<div class="form-search-section">
		<div class="container course-landingpage">
			<div class="">
				<form action="" id="form-search-custom-course">

					<input type="text" name="keyword" class="keyword" placeholder="Search from over 300 courses" value="<?=(!empty($_GET['keyword'])) ? $_GET['keyword'] : ''?>"/>
					<button class="search-btn et_pb_promo_button et_pb_button">Search</button>
				</form>
				<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>

		</div>
	</div>
	
	<div class="breadcrumbs-wrapper"><div class="course-breadcrumbs"><?=course_breadcrumbs();?></div></div>

	<div class="container all-course-landingpage">
	
		<div class="element-hider">
			<div class="refer-to-a-friend-section inquire-now-to-custom-courses" id="inquire-now-to-custom-courses"><?=do_shortcode('[contact-form-7 id="1405" title="Inquire Now"]');?></div>
		</div>
		
		<?php
			$separate_by_domain = array();
			foreach(get_custom_course() as $key=>$course){
				$separate_by_domain[$course->cat_parent_id][$course->cat_id][] = $course;
			}
		?>
		
		<div class="course-list">
			<?php foreach($separate_by_domain as $domain_key=>$domain){ ?>
				<h5 class="category-parent"><?=get_cat_info($domain_key)->name;?></h5>
				<?php foreach($domain as $subdomain_key=>$subdomain){ ?>
					<div class="sub-domain-wrapper">
						<h5 class="course-category cat_parent_<?=$domain_key;?>"><?=get_cat_info($subdomain_key)->name;?></h5>
						<?php if( count($subdomain) ){?>
							<div class="course-category-nav">
								<ul>
									<?php foreach($subdomain as $course_key=>$course){ ?>
										<li class="cat_parent_<?=$course->cat_parent_id;?>">
											<span><?=$course->post_title;?></span>
											<a href="#inquire-now-to-custom-courses" class="inquire-btn fancybox no_smooth_scroll" data-course="<?=$course->post_title;?>">Inquire Now</a>
										</li>
									<?php }/*endforeach*/?>
								</ul>
							</div>
						<?php }/*endif*/?>
					</div>
				<?php }/*endforeach*/?>
			<?php }/*endforeach*/?>
		</div><!--end of  course-list-->
		
		
		<div class="clearfix"></div>
	</div>
</div> <!-- #main-content -->

<?php get_footer(); ?>