<?php
/*
Template Name: Certificate
*/
?>

<!DOCTYPE HTML>
<html lang="en-US">
<head>
	<meta charset="UTF-8">
	<META NAME="ROBOTS" CONTENT="NOINDEX, NOFOLLOW">
	<title>Certificate Verifier - APEX Global</title>
	<style type="text/css">
		body, html{background-color:#fff;font-family:Tahoma, Geneva, sans-serif;color:#333;font-size:16px;margin:0;padding:0;}
		h1,h2{font-size:30px;}
		h3{font-size:25px;}
		h4{font-size:20px;}
		h5{font-size:18px;}
		.cert-wrapper{width:640px;border:10px solid #526171;margin:0 auto;box-sizing:border-box;padding:30px;}
		.cert-wrapper .brand-logo{display:block;margin:0 auto;width:160px;height:auto;}
		.cert-wrapper .cert-footer-bg{display:block;margin:0 auto;width:100%;height:auto;}
		.cert-wrapper .cert-title{text-align:center;margin:30px 0;}
		.cert-wrapper table.info-table{width:80%;margin:50px auto 70px auto;}
		.cert-wrapper table.info-table .avatar{width:150px;height:auto;max-height:200px;background-color:#efefef;border:1px solid #333;}
		.cert-wrapper table.info-table td{padding:3px 0;}
	</style>
</head>
<body>
	<div class="cert-wrapper">
		<?php
			$cert_id = $_GET['certid'];
			$cert_info = verify_cert_number($cert_id);
			if(!empty($cert_id) AND !empty($cert_info)){
		?>
			<img class="brand-logo" src="/wp-content/uploads/2015/09/apex-logo-200x200.png" alt="" />
			<h1 class="cert-title">Certificate Verifier</h1>
			<table class="info-table" cellpadding="0" cellspacing="0" border="0">
					<?php
						$avatar = CFS()->get('cert_avatar',$cert_info->ID);
						$avatar = (empty($avatar)) ? '/wp-content/themes/apex/images/inugget-no-image.png' : $avatar;
					?>
					<tr>
						<td style="width:200px;"><div class="fname">First Name:</div></td>
						<td><?=CFS()->get('cert_fname',$cert_info->ID);?></td>
					<tr>
					<tr>
						<td><div class="lname">Last Name:</div></td>
						<td><?=CFS()->get('cert_lname',$cert_info->ID);?></td>
					<tr>
					<tr>
						<td><div class="country">Country:</div></td>
						<td><?=CFS()->get('cert_country',$cert_info->ID);?></td>
					<tr>
					<tr>
						<td><div class="address">Address:</div></td>
						<td><?=CFS()->get('cert_addr',$cert_info->ID);?></td>
					<tr>
					<tr>
						<td>&nbsp;</td><td>&nbsp;</td>
					<tr>
					<tr>
						<td><div class="qual">Qualification:</div></td>
						<td><?=CFS()->get('cert_qualification',$cert_info->ID);?></td>
					<tr>
					<tr>
						<td><div class="cert_number">Certificate Number:</div></td>
						<td><?=CFS()->get('cert_number',$cert_info->ID);?></td>
					<tr>
					<tr>
						<td><div class="date_training">Date of Training:</div></td>
						<td><?=CFS()->get('cert_date',$cert_info->ID);?></td>
					<tr>
					<tr>
						<td><div class="ssuing_auth:">Issuing Authority:</div></td>
						<td><?=CFS()->get('cert_issuing_auth',$cert_info->ID);?></td>
					<tr>
			</table>
			<img class="cert-footer-bg" src="/wp-content/uploads/2015/12/cert-footer-bg-1.jpg" alt="" />
		<?php }else{?>
			<h1 class="cert-title">Invalid Certificate Number</h1>
		<?php }/*endif*/?>
	</div>
</body>
</html>

