<?php
get_header();

$meta = get_post_meta(get_the_ID());

$args = array(
	'post_type' => 'vq_course'
);

$courses1 = new WP_Query($args);

while($courses1->have_posts()) {
	$courses1->the_post();

	$crsList[] = get_the_title();
}

echo "<script> crsList = " . json_encode($crsList) . " </script>>";

?>
	<div class="bootstrap-iso">
		<div class="e-learning-banner" style="background-image: url(<?php echo get_the_post_thumbnail_url(get_the_ID()); ?>)">
			<div class="container">
				<div class="row">
					<div class="e-learning-heading">
						<h2><?php echo get_the_title() ?></h2>
						<h3><?php echo get_the_excerpt(); ?></h3>
					</div>
				</div>
			</div>
		</div>
		<div class="learning-profile-bg">
			<div class="container">
				<div class="row">
					<?php echo get_the_content(); ?>
				</div>
			</div>
		</div>
		<div class="container" style="margin-top: 15px; margin-bottom: 30px;">
			<div class="row">
				<div class="col-sm-8">
                    <video src="<?php echo $meta['course_attachment_url'][0]; ?>" width="100%" controls>

                    </video>
                    <div class="course-box">
                        <div class="col-sm-3 col-padding">
                            <?php the_post_thumbnail('thumbnail') ?>
                        </div>
                        <div class="col-sm-6">
                            <div class="course-heading">
                                <?php echo $meta['listing_content'][0]; ?>
                            </div>
                        </div>
                        <div class="col-sm-3 col-padding">
                            <div class="download-course-box">
                                <div class="course-heading">
                                    <h4><a href="<?php echo get_permalink(get_page_by_path('download-all')) ?>">Download <br>course list</a></h4>
                                </div>

                                <div class="text-center">

                                </div>
                            </div>
                        </div>
                        <div class="clear"></div>
                    </div>

				</div>
				<div class="col-sm-4">
					<?php echo  do_shortcode('[contact-form-7 id="6212" title="Inquiry Form"]'); ?>
				</div>
			</div>
		</div>

		<?php  echo do_shortcode('[vq_short_banner 
	        txtClr="#fff" 
	        btnClr="#fff" 
	        bgClr="#2898c4" 
	        btnBg="#f89f18" 
	        btnTxt="Sign Up today" 
	        txt="Ready to begin?"]'); ?>

	</div>
<?php
get_footer();
?>