<?php

/**
 * Plugin class
 **/
if ( ! class_exists( 'CT_TAX_META' ) ) {

	class CT_TAX_META {

		public function __construct() {
			//
		}

		/*
		 * Initialize the class and start calling our hooks and filters
		 * @since 1.0.0
		*/
		public function init() {
			add_action( 'vq_course_taxonomy_add_form_fields', array ( $this, 'add_category_image' ), 10, 2 );
			add_action( 'created_vq_course_taxonomy', array ( $this, 'save_category_image' ), 10, 2 );
			add_action( 'vq_course_taxonomy_edit_form_fields', array ( $this, 'update_category_image' ), 10, 2 );
			add_action( 'edited_vq_course_taxonomy', array ( $this, 'updated_category_image' ), 10, 2 );
			add_action( 'admin_enqueue_scripts', array( $this, 'load_media' ) );
			add_action( 'admin_footer', array ( $this, 'add_script' ) );
		}

		public function load_media() {
			wp_enqueue_media();
		}

		/*
		 * Add a form field in the new category page
		 * @since 1.0.0
		*/
		public function add_category_image ( $taxonomy ) { ?>
            <div class="form-field term-group">
                <label for="vq_course_taxonomy-image-id">Image</label>
                <input type="hidden" id="vq_course_taxonomy-image-id" name="vq_course_taxonomy-image-id" class="custom_media_url" value="">
                <div id="vq_course_taxonomy-image-wrapper"></div>
                <p>
                    <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="Add Image" />
                    <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="Remove Image" />
                </p>
                <label for="">Redirect Link: </label>
                <input type="text" class="form-control"  name="vq_course_ct_tax_redirect" />
            </div>
			<?php
		}

		/*
		 * Save the form field
		 * @since 1.0.0
		*/
		public function save_category_image ( $term_id, $tt_id ) {
			if( isset( $_POST['vq_course_taxonomy-image-id'] ) && '' !== $_POST['vq_course_taxonomy-image-id'] ){
				$image = $_POST['vq_course_taxonomy-image-id'];
				add_term_meta( $term_id, 'vq_course_taxonomy-image-id', $image, true );
			}
			$link = $_POST['vq_course_ct_tax_redirect'];
			add_term_meta( $term_id, 'vq_course_ct_tax_redirect', $link, true );
		}

		/*
		 * Edit the form field
		 * @since 1.0.0
		*/
		public function update_category_image ( $term, $taxonomy ) { ?>
            <tr class="form-field term-group-wrap">
                <th scope="row">
                    <label for="vq_course_taxonomy-id"><?php __( 'Image'); ?></label>
                </th>
                <td>
					<?php $image_id = get_term_meta ( $term -> term_id, 'vq_course_taxonomy-image-id', true ); ?>
                    <input type="hidden" id="vq_course_taxonomy-image-id" name="vq_course_taxonomy-image-id" value="<?php echo $image_id; ?>">
                    <div id="vq_course_taxonomy-image-wrapper">
						<?php if ( $image_id ) { ?>
							<?php echo wp_get_attachment_image ( $image_id, 'thumbnail' ); ?>
						<?php } ?>
                    </div>
                    <p>
                        <input type="button" class="button button-secondary ct_tax_media_button" id="ct_tax_media_button" name="ct_tax_media_button" value="Add Image" />
                        <input type="button" class="button button-secondary ct_tax_media_remove" id="ct_tax_media_remove" name="ct_tax_media_remove" value="Remove Image" />
                    </p>
                    <?php $link = get_term_meta ( $term -> term_id, 'vq_course_ct_tax_redirect', true ); ?>
                    <label for="">Redirect Link: </label>
                    <input type="text" class="form-control"  name="vq_course_ct_tax_redirect" value="<?php echo $link; ?>"/>
                </td>
            </tr>
			<?php
		}

		/*
		 * Update the form field value
		 * @since 1.0.0
		 */
		public function updated_category_image ( $term_id, $tt_id ) {
			if( isset( $_POST['vq_course_taxonomy-image-id'] ) && '' !== $_POST['vq_course_taxonomy-image-id'] ){
				$image = $_POST['vq_course_taxonomy-image-id'];
				update_term_meta ( $term_id, 'vq_course_taxonomy-image-id', $image );
			} else {
				update_term_meta ( $term_id, 'vq_course_taxonomy-image-id', '' );
			}
			$link = $_POST['vq_course_ct_tax_redirect'];
			update_term_meta ( $term_id, 'vq_course_ct_tax_redirect', $link );

		}

		/*
		 * Add script
		 * @since 1.0.0
		 */
		public function add_script() { ?>
            <script>
                jQuery(document).ready( function($) {
                    function ct_media_upload(button_class) {
                        var _custom_media = true,
                            _orig_send_attachment = wp.media.editor.send.attachment;
                        $('body').on('click', button_class, function(e) {
                            var button_id = '#'+$(this).attr('id');
                            var send_attachment_bkp = wp.media.editor.send.attachment;
                            var button = $(button_id);
                            _custom_media = true;
                            wp.media.editor.send.attachment = function(props, attachment){
                                if ( _custom_media ) {
                                    $('#vq_course_taxonomy-image-id').val(attachment.id);
                                    $('#vq_course_taxonomy-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
                                    $('#vq_course_taxonomy-image-wrapper .custom_media_image').attr('src',attachment.url).css('display','block');
                                } else {
                                    return _orig_send_attachment.apply( button_id, [props, attachment] );
                                }
                            }
                            wp.media.editor.open(button);
                            return false;
                        });
                    }
                    ct_media_upload('.ct_tax_media_button.button');
                    $('body').on('click','.ct_tax_media_remove',function(){
                        $('#vq_course_taxonomy-image-id').val('');
                        $('#vq_course_taxonomy-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
                    });

                    $(document).ajaxComplete(function(event, xhr, settings) {
                        var queryStringArr = settings.data.split('&');
                        if( $.inArray('action=add-tag', queryStringArr) !== -1 ){
                            var xml = xhr.responseXML;
                            $response = $(xml).find('term_id').text();
                            if($response!=""){
                                // Clear the thumb image
                                $('#vq_course_taxonomy-image-wrapper').html('');
                            }
                        }
                    });
                });
            </script>
		<?php }

	}

	$CT_TAX_META = new CT_TAX_META();
	$CT_TAX_META -> init();

}