<?php
/*
Template Name: Courses
*/
get_header();
$is_page_builder_used = et_pb_is_pagebuilder_used( get_the_ID() ); 
?>

<?php if( isset($_GET['keyword']) ){?>
	<script type="text/javascript">	
		//Check if the Keword is set, then apply the search based on the keyword
		jQuery(function(){
			custom_course_search('<?=$_GET['keyword'];?>', '/wp-admin/admin-ajax.php');
		});
	</script>
<?php }?>

<div id="main-content">

	<?php include_once('module/banner_course_landingpage.php');?>
	<div class="breadcrumbs-wrapper"><div class="course-breadcrumbs"><?=course_breadcrumbs();?></div></div>

	<div class="form-search-section">
		<div class="container course-landingpage">
			<div class="content-left">
				<form action="" id="form-search-course">
					<input type="text" name="keyword" class="keyword" placeholder="Search from over 300 courses" value="<?=(!empty($_GET['keyword'])) ? $_GET['keyword'] : ''?>"/>
					<button class="search-btn et_pb_promo_button et_pb_button">Search</button>
				</form>
				<div class="clearfix"></div>
			</div>
			<div class="clearfix"></div>
		</div>
	</div>

	
	<div class="container course-landingpage">
	
		
		<div class="content-left">
			
			<div class="course-list">
				<?php
					if( isset($_GET['keyword'])==false ){	
						$course_display_counter = 0;
						foreach(get_course_by_category(99) as $key=>$val){
				?>
				
							<div class="category-separator">
								<h3 class="category-name float_l"><?=$val['name']?></h3>
								<a class="viewmore float_r" href="<?=get_course_category_url($key);?>">View More</a>
								<div class="clearfix"></div>
							</div>
							
							<?php $course_counter = 0;?>
							<?php foreach($val['item'] as $k_item=>$v_item){?>
								<?php $get_course_domain = get_course_domain($v_item->ID); ?>
								<div class="course-item">
									<a href="<?=get_permalink($v_item->ID);?>">
										<div class="image-wrapper"><?=get_course_thumb($v_item->ID);?></div>
										<div class="content-wrapper">
											<div class="course-title"><?=(strlen($v_item->post_title) > 40) ? substr($v_item->post_title,0,37).'...' : $v_item->post_title;?></div>
											<div class="course-type">
												<?php
													$course_type = CFS()->get('course_type', $v_item->ID);
													if( !empty($course_type) ){ echo reset($course_type); }
												?>
											</div>
											<div class="course-days"><?=CFS()->get('course_days', $v_item->ID);?></div>
										</div>
									</a>
									<a href="<?=get_permalink($v_item->ID);?>" class="course-item-hover"></a>
								</div>
								
								<?php 
									$course_display_counter++;
									$course_counter++;
									if($course_counter>=3){break;$course_counter=0;}
								?>
							<?php }/*endforeach*/?>
				<?php 
							if($course_display_counter>=12){break;}
						}/*endforeach*/
					}/*endif*/
				?>
				
				<div class="clearfix"></div>
			</div>
			
			
			<div class="clearfix"></div>
		</div>
		
		
		<div class="content-right">
			<?php include_once('module/browse_course_category.php'); ?>
			<div class="enquiry-section"><?=do_shortcode('[contact-form-7 id="630"]');?></div>
			<?php include_once('module/download_full_list_course.php');?>
			<div class="clearfix"></div>
		</div>
		<div class="clearfix"></div>
	</div>
</div> <!-- #main-content -->

<?php get_footer(); ?>