<?php

add_action('add_meta_boxes', 'vq_add_custom_meta_boxes', 10, 2);

function vq_render_course_shortcode_metabox() {

	echo '[vq_course_banner id="'. get_the_ID() .'"]';
}

function vq_render_course_attachment_metabox() {
	wp_enqueue_media();

	$file = file_get_contents(__DIR__ . '/includes/attachmentAndPrice.html');

	$attachment_id = get_post_meta(get_the_ID(), 'course_attachment_id', true);
	$attachment_title = get_post_meta(get_the_ID(), 'course_attachment_url', true);
	$courseFee = get_post_meta(get_the_ID(), 'course_fee', true);
	$listing_content = get_post_meta(get_the_ID(), 'listing_content', true);

	if($attachment_id > 0) {
		$file = str_replace('[[ATTACHMENT]]', $attachment_title, $file);
		$file = str_replace('[[ATTACHMENT_ID]]', $attachment_id, $file);
	} else {
		$file = str_replace('[[ATTACHMENT]]', 'NONE', $file);
		$file = str_replace('[[ATTACHMENT_ID]]', -1, $file);
	}
	if($courseFee > 0) {
		$file = str_replace('[[PRICE]]', $courseFee, $file);
	} else {
		$file = str_replace('[[PRICE]]', '', $file);
	}
	if($listing_content) {
		$file = str_replace('[[LISTING_CONTENT]]', $listing_content, $file);
	} else {
		$file = str_replace('[[LISTING_CONTENT]]', '', $file);
	}

	echo $file;
}

function vq_add_custom_meta_boxes() {

	add_meta_box(
		'vq_short_banner_shortcode_metabox',
		'Course Shortcode',
		'vq_render_course_shortcode_metabox',
		'vq_course',
		'side',
		'high'
	);

	add_meta_box(
		'vq_course_attachment_metabox',
		'Media & Settings',
		'vq_render_course_attachment_metabox',
		'vq_course',
		'advanced',
		'high'
	);

	add_meta_box(
		'vq_lms_orders_meta_box',
		'Order Information',
		'vq_render_lms_order_metabox',
		'vq_lms_orders',
		'normal',
		'default'
	);

}

function vq_render_lms_order_metabox() {

	$price = get_post_meta(get_the_ID(), 'total_amount', true);
	$payment_status = get_post_meta(get_the_ID(), 'payment_status', true);


	if($price == null) $price = "";
	if($payment_status == null) $payment_status = "IN QUEUE";

	wp_enqueue_style('vq-lms-admin-custom', plugin_dir_url(__FILE__) . 'src/styles.css');

	$file = file_get_contents(__DIR__ . '/includes/order-info.html');

	$file = str_replace('[[PRICE]]', $price, $file);
	$file = str_replace('[[PAY_STAT]]', $payment_status, $file);

	echo $file;

}


