<?php


add_action('admin_menu', 'vq_lms_settings_page');

add_action('admin_init', 'vq_lms_settings_init');
add_action('admin_init', 'vq_lms_payment_settings_init');
add_action('admin_init', 'vq_lms_email_settings_init');


function vq_lms_email_settings_init() {

	register_setting('vq_lms_settings', 'vq_lms_payment_email_subject');
    register_setting('vq_lms_settings', 'vq_lms_download_email_subject');
	register_setting('vq_lms_settings', 'vq_lms_payment_email_template');
	register_setting('vq_lms_settings', 'vq_lms_payment_notify_email');

	add_settings_section(
		'vq_lms_email_settings_section',
		'Email Notification Settings',
		'vq_lms_email_settings_section_cb',
		'vq_lms_settings'
	);

	add_settings_field(
		'vq_lms_payment_email_subject',
		'Email Subject',
		'vq_lms_payment_email_subject_cb',
		'vq_lms_settings',
		'vq_lms_email_settings_section'
	);

    add_settings_field(
        'vq_lms_download_email_subject',
        'Email Subject',
        'vq_lms_download_email_subject_cb',
        'vq_lms_settings',
        'vq_lms_email_settings_section'
    );

	add_settings_field(
		'vq_lms_payment_email_template',
		'Email Template',
		'vq_lms_payment_email_template_cb',
		'vq_lms_settings',
		'vq_lms_email_settings_section'
	);

	add_settings_field(
		'vq_lms_payment_notify_email',
		'Notify URL',
		'vq_lms_payment_notify_email_cb',
		'vq_lms_settings',
		'vq_lms_email_settings_section'
	);


}


function vq_lms_email_settings_section_cb() {
    echo "Enter Email configuration on order placement";
}


function vq_lms_payment_email_template_cb() {
	$options = get_option('vq_lms_payment_email_template');

	wp_editor($options, 'vq_lms_payment_email_template', array(
	        'textarea_rows' => 10
    ));
	?> <p class="description">Use [[ORDER_DETAILS]] for Order Details</p> <?php
	?> <p class="description">Use [[PRICE]] for Price</p> <?php
	?> <p class="description">Use [[STATUS]] for Status</p> <?php
	?> <p class="description">Use [[RESPONSE]] for Response</p> <?php
}

function vq_lms_payment_notify_email_cb() {
	$option = get_option('vq_lms_payment_notify_email');

	?>
    <input type="email"
           name="vq_lms_payment_notify_email"
           value="<?php echo $option; ?>"
    >
    <p class="description">You will be notified on this URL when an order is placed.</p>
	<?php
}

function vq_lms_payment_email_subject_cb() {
	$option = get_option('vq_lms_payment_email_subject');

	?>
    <input type="text"
           name="vq_lms_payment_email_subject"
           value="<?php echo $option; ?>"
    >
    <p class="description">Subject Email Payment</p>
	<?php

}

function vq_lms_download_email_subject_cb() {
    $option = get_option('vq_lms_download_email_subject');

    ?>
    <input type="text"
           name="vq_lms_download_email_subject"
           value="<?php echo $option; ?>"
    >
    <p class="description">Subject Email Download</p>
    <?php

}



function vq_lms_payment_settings_init()
{
    register_setting('vq_lms_settings', 'vq_lms_payment_merchant_id');
    register_setting('vq_lms_settings', 'vq_lms_payment_merchant_name');
    register_setting('vq_lms_settings', 'vq_lms_payment_company_name');
    register_setting('vq_lms_settings', 'vq_lms_payment_merchant_key');

    add_settings_section(
        'vq_lms_payment_settings_section',
        'Payment Gateway Settings',
        'vq_lms_general_settings_section_cb',
        'vq_lms_settings'
    );

    add_settings_field(
        'vq_lms_payment_settings_merchant_id',
        'Merchant ID',
        'vq_lms_payment_settings_merchant_id',
        'vq_lms_settings',
        'vq_lms_payment_settings_section'
    );

    add_settings_field(
        'vq_lms_payment_merchant_name',
        'Merchant Name',
        'vq_lms_payment_merchant_name',
        'vq_lms_settings',
        'vq_lms_payment_settings_section'
    );

    add_settings_field(
        'vq_lms_payment_company_name',
        'Company Name',
        'vq_lms_payment_company_name',
        'vq_lms_settings',
        'vq_lms_payment_settings_section'
    );

    add_settings_field(
        'vq_lms_payment_merchant_key',
        'Merchant Key',
        'vq_lms_payment_merchant_key',
        'vq_lms_settings',
        'vq_lms_payment_settings_section'
    );
}

function vq_lms_general_settings_section_cb()
{
    echo "Settings related to payment gateway.";
}

function vq_lms_payment_merchant_key()
{
    $merchant_key = get_option('vq_lms_payment_merchant_key');

    ?>
    <input type="text"
           name="vq_lms_payment_merchant_key"
           value="<?php echo $merchant_key; ?>"
    />
    <p class="description">
        <?php esc_html_e('Specify Merchant Key of payment gateway.', 'vq_lms_settings'); ?>
    </p>
    <?php
}

function vq_lms_payment_company_name()
{
    $company_name = get_option('vq_lms_payment_company_name');

    ?>
    <input type="text"
           name="vq_lms_payment_company_name"
           value="<?php echo $company_name; ?>"
    />
    <p class="description">
        <?php esc_html_e('Specify Company Name of payment gateway.', 'vq_lms_settings'); ?>
    </p>
    <?php
}

function vq_lms_payment_merchant_name()
{
    $merchant_name = get_option('vq_lms_payment_merchant_name');

    ?>
    <input type="text"
           name="vq_lms_payment_merchant_name"
           value="<?php echo $merchant_name; ?>"
    />
    <p class="description">
        <?php esc_html_e('Specify Merchant Name of payment gateway.', 'vq_lms_settings'); ?>
    </p>
    <?php
}

function vq_lms_payment_settings_merchant_id()
{
    $merchant_id = get_option('vq_lms_payment_merchant_id');

    ?>
    <input type="text"
           name="vq_lms_payment_merchant_id"
           value="<?php echo $merchant_id; ?>"
    />
    <p class="description">
        <?php esc_html_e('Specify Merchant ID of payment gateway.', 'vq_lms_settings'); ?>
    </p>
    <?php
}

function vq_lms_settings_init()
{
    register_setting('vq_lms_settings', 'vq_lms_settings_options');

    add_settings_section(
        'vq_lms_settings_section_developers',
        'General Settings',
        'vq_lms_settings_section_developers_cb',
        'vq_lms_settings'
    );

    add_settings_field(
        'vq_lms_settings_field_general_price',
        'Default Course Price',
        'vq_lms_settings_field_price_cb',
        'vq_lms_settings',
        'vq_lms_settings_section_developers',
        [
            'label_for' => 'vq_lms_settings_field_general_price',
            'class' => 'vq_lms_settings_row',
            'vq_lms_settings_custom_data' => 'custom',
        ]
    );


	add_settings_field(
		'vq_lms_settings_field_intro_price',
		'Intro Price',
		'vq_lms_settings_field_intro_price_cb',
		'vq_lms_settings',
		'vq_lms_settings_section_developers',
		[
			'label_for' => 'vq_lms_settings_field_intro_price',
			'class' => 'vq_lms_settings_row',
			'vq_lms_settings_custom_data' => 'custom',
		]
	);

    add_settings_field(
        'vq_lms_settings_field_shortcode',
        'Banner Shortcode',
        'vq_lms_settings_field_shortcode_cb',
        'vq_lms_settings',
        'vq_lms_settings_section_developers'
    );

    add_settings_field(
        'vq_lms_settings_field_currency_name',
        'Currency Name',
        'vq_lms_settings_field_currency_name_cb',
        'vq_lms_settings',
        'vq_lms_settings_section_developers',
        [
            'label_for' => 'vq_lms_settings_field_currency_name',
            'class' => 'vq_lms_settings_row',
            'vq_lms_settings_custom_data' => 'custom',
        ]
    );

    add_settings_field(
        'vq_lms_settings_field_currency_symbol',
        'Currency Symbol',
        'vq_lms_settings_field_currency_symbol_cb',
        'vq_lms_settings',
        'vq_lms_settings_section_developers',
        [
            'label_for' => 'vq_lms_settings_field_currency_symbol',
            'class' => 'vq_lms_settings_row',
            'vq_lms_settings_custom_data' => 'custom',
        ]
    );

    add_settings_field(
        'vq_lms_settings_field_video',
        'Video',
        'vq_lms_settings_field_video_cb',
        'vq_lms_settings',
        'vq_lms_settings_section_developers',
        [
            'label_for' => 'vq_lms_settings_field_video',
            'class' => 'vq_lms_settings_row',
            'vq_lms_settings_custom_data' => 'custom',
        ]
    );

    add_settings_field(
        'vq_lms_settings_field_courselist',
        'Courselist',
        'vq_lms_settings_field_courselist_cb',
        'vq_lms_settings',
        'vq_lms_settings_section_developers',
        [
            'label_for' => 'vq_lms_settings_field_courselist',
            'class' => 'vq_lms_settings_row',
            'vq_lms_settings_custom_data' => 'custom',
        ]
    );
}

function vq_lms_settings_section_developers_cb($args)
{

}

function vq_lms_settings_field_intro_price_cb($args) {
	$options = get_option('vq_lms_settings_options');

	?>
    <input type="text"
           name="vq_lms_settings_options[<?php echo esc_attr($args['label_for']); ?>]"
           value="<?php echo $options[$args['label_for']]; ?>"
    >
    <p class="description">
		<?php esc_html_e('Your entered price will be listed as intro price (special offer).', 'vq_lms_settings'); ?>
    </p>
	<?php
}

function vq_lms_settings_field_price_cb($args)
{
    $options = get_option('vq_lms_settings_options');

    ?>
    <input type="text"
           name="vq_lms_settings_options[<?php echo esc_attr($args['label_for']); ?>]"
           value="<?php echo $options[$args['label_for']]; ?>"
    >
    <p class="description">
        <?php esc_html_e('Your entered price will be listed as default price for all courses unless specified for each.', 'vq_lms_settings'); ?>
    </p>
    <?php
}

function vq_lms_settings_field_currency_name_cb($args)
{
    $options = get_option('vq_lms_settings_options');

    ?>
    <input type="text"
           name="vq_lms_settings_options[<?php echo esc_attr($args['label_for']); ?>]"
           value="<?php echo $options[$args['label_for']]; ?>"
    >
    <p class="description">
        <?php esc_html_e('Your entered currency will be used for whole LMS system listing.', 'vq_lms_settings'); ?>
    </p>
    <?php
}

function vq_lms_settings_field_currency_symbol_cb($args)
{
    $options = get_option('vq_lms_settings_options');

    ?>
    <input type="text"
           name="vq_lms_settings_options[<?php echo esc_attr($args['label_for']); ?>]"
           value="<?php echo $options[$args['label_for']]; ?>"
    >
    <p class="description">
        <?php esc_html_e('Enter Currency Symbol.', 'vq_lms_settings'); ?>
    </p>
    <?php
}

function vq_lms_settings_field_video_cb($args)
{

    wp_enqueue_media();

    $options = get_option('vq_lms_settings_options');

    if ($options[$args['label_for']]) {
        ?>
        <div style="width: 200px;" id="video_holder">
            <video id="vid" src="<?php echo $options[$args['label_for']]; ?>">
            </video>
        </div>
        <?php
    }

    ?>

    <input type="button"
           id="vq_lms_video"
           class="button"
           value="Upload Video">
    <input type="button"
           id="vq_lms_remove_video"
           class="button"
           value="Remove Video">

    <input type="hidden"
           id="vq_lms_video_hidden"
           name="vq_lms_settings_options[<?php echo esc_attr($args['label_for']); ?>]"
           value="<?php echo $options[$args['label_for']]; ?>">

    <p class="description">
        <?php esc_html_e('video attachment to show.', 'vq_lms_settings'); ?>
    </p>

    <script>
        var mediaUploader;
        jQuery("#vq_lms_remove_video").on('click', function () {
            jQuery("#vq_lms_video_hidden").val('');
            jQuery("#vid").attr('src', '');
        });
        jQuery('#vq_lms_video').on('click', function (e) {
            e.preventDefault();
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }
            mediaUploader = wp.media.frames.file_frame = wp.media({
                title: 'Select Video',
                button: {
                    text: 'Choose Video'
                },
                multiple: false
            });
            mediaUploader.on('select', function () {
                attachment = mediaUploader.state().get('selection').first().toJSON();
                jQuery("#vq_lms_video_hidden").val(attachment.url);
                jQuery("#vid").attr('src', attachment.url);
            });
            mediaUploader.open();
        });
    </script>

    <?php
}

/////
function vq_lms_settings_field_courselist_cb($args)
{

    wp_enqueue_media();

    $options = get_option('vq_lms_settings_options');

    if ($options[$args['label_for']]) {
        ?>
        <div style="width: 200px;" id="courselist_holder">
            <file id="clist" src="<?php echo $options[$args['label_for']]; ?>">
            </file>
        </div>
        <?php
    }

    

    if($options[$args['label_for']] == ''){
    ?>
    <input type="text" name="attachment" value="<?php echo $options[$args['label_for']]; ?>" placeholder ="No File Uploaded" disabled ="true" >

    <?php } else{ ?>
    <iframe src="<?php echo $options[$args['label_for']]; ?>" style="width:200px; height:120px;" frameborder="0"></iframe><br><div>&nbsp;</div> <?php } ?>

    <input type="button"
           id="vq_lms_courselist"
           class="button"
           value="Upload Course List">
    <input type="button"
           id="vq_lms_remove_courselist"
           class="button"
           value="Remove">

    <input type="hidden"
           id="vq_lms_courselist_hidden"
           name="vq_lms_settings_options[<?php echo esc_attr($args['label_for']); ?>]"
           value="<?php echo $options[$args['label_for']]; ?>">

    <p class="description">
        <?php esc_html_e('attachment file.', 'vq_lms_settings'); ?>
    </p>

    <script>
        var mediaUploader;
        jQuery("#vq_lms_remove_courselist").on('click', function () {
            jQuery("#vq_lms_courselist_hidden").val('');
            jQuery("#clist").attr('src', '');
        });
        jQuery('#vq_lms_courselist').on('click', function (e) {
            e.preventDefault();
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }
            mediaUploader = wp.media.frames.file_frame = wp.media({
                title: 'Select File',
                button: {
                    text: 'Choose File'
                },
                multiple: false
            });
            mediaUploader.on('select', function () {
                attachment = mediaUploader.state().get('selection').first().toJSON();

                    var str = attachment.url;
                    var url = str.replace("http://", "https://");

                jQuery("#vq_lms_courselist_hidden").val(url);

                jQuery("#clist").attr('src', url);

            });
            mediaUploader.open();
        });
    </script>

    <?php
}
/////

function vq_lms_settings_field_shortcode_cb()
{
    echo '[vq_short_banner bgClr="" btnBg="" txt="" txtClr="" btnClr="" btnLink="" btnTxt=""]';
}

function vq_lms_settings_page()
{

    add_submenu_page('edit.php?post_type=vq_course',
        'Settings',
        'Settings',
        'manage_options',
        'vq_lms_settings',
        'vq_lms_settings_page_html'
    );
}

function vq_lms_settings_page_html()
{
    if (!current_user_can('manage_options')) {
        return;
    }

    if (isset($_GET['settings-updated'])) {
        add_settings_error(
            'vq_lms_settings_messages',
            'vq_lms_settings_message',
            'Settings Saved',
            'updated'
        );
    }

    settings_errors('vq_lms_settings_messages');
    ?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        <form action="options.php" method="post">
            <?php
            settings_fields('vq_lms_settings');
            do_settings_sections('vq_lms_settings');
            submit_button('Save Settings');
            ?>
        </form>
    </div>
    <?php
}