<?php
$lmsVersion = "0.4";
add_action('wp_enqueue_scripts', 'enqueue_admin_css');
add_filter('template_include', 'use_lms_template', 99);

function enqueue_admin_css()
{
    global $lmsVersion;
    wp_enqueue_style("lms-reset", plugin_dir_url(__FILE__) . "template/css/reset.css", array('lms-bootstrap'), $lmsVersion, 'all');
    wp_enqueue_style("lms-bootstrap", plugin_dir_url(__FILE__) . "template/css/bootstrap.min.css", array(), $lmsVersion, 'all');
    wp_enqueue_style("lms-styles", plugin_dir_url(__FILE__) . "template/css/lms.css", array('lms-bootstrap'), $lmsVersion, 'all');

    wp_enqueue_script("lms-script", plugin_dir_url(__FILE__) . "template/js/lms.js", array("jquery"), $lmsVersion, true);
}

function use_lms_template($data)
{
	global $post;
    if(is_page('lms')){
         return __DIR__ . "/template/e-learning.php";
    }

    if(is_page('lms-checkout')){
         return __DIR__ . "/template/learner-detail.php";
    }

    else if(is_page('lms-courses')) {
    	return __DIR__  . "/template/it-course.php";
    }

    else if(is_page('download-all')) {
    	return __DIR__ . '/template/download-now.php';
    }

    else if(is_page('thank-you-download') || is_page('thank-you-pricing')) {
    	return __DIR__ . '/template/thank-you-download.php';
    }
	else if ($post->post_type === 'vq_course') {
		return __DIR__ . '/template/single-course.php';
	}
	else if(is_page('lms-pricing')) {
    	return __DIR__ . '/template/pricing-request.php';
	}
	else if(is_page('lms-notify')) {
    	include(__DIR__ . '/template/order-redirection.php');
    	exit;
	}

    return $data;
}
