<?php
/*
Plugin Name: Really Simple Breadcrumb
Plugin URI: http://www.christophweil.de
Description: This is a really simple WP Plugin which lets you use Breadcrumbs for Pages!
Version: 1.0.2
Author: Christoph Weil
Author URI: http://www.christophweil.de
Update Server: 
Min WP Version: 3.2.1
Max WP Version: 
*/


	function simple_breadcrumb() {
		global $post;
		$separator = "&nbsp;&nbsp;<span class='fa fa-angle-right'></span>&nbsp;&nbsp;"; // Simply change the separator to what ever you need e.g. / or >
		
		$trail .= '<div class="breadcrumbs-wrapper"><div class="breadcrumb course-breadcrumbs">';
		if (!is_front_page()) {
			$trail .= '<a href="';
			$trail .= get_option('home');
			$trail .= '">';
			//bloginfo('name');
			$trail .= /*get_bloginfo('name')*/'<span class="fa fa-home fa-lg"></span>';
			$trail .= "</a> ".$separator;
			if ( is_category() || is_single() ) {
				the_category(', ');
				if ( is_single() ) {
					$trail .= $separator;
					$trail .= get_the_title();
				}
			} elseif ( is_page() && $post->post_parent ) {
				$home = get_page(get_option('page_on_front'));
				for ($i = count($post->ancestors)-1; $i >= 0; $i--) {
					if (($home->ID) != ($post->ancestors[$i])) {
						$trail .= '<a href="';
						$trail .= get_permalink($post->ancestors[$i]); 
						$trail .= '">';
						$trail .= get_the_title($post->ancestors[$i]);
						$trail .= "</a>".$separator;
					}
				}
				$trail .= get_the_title();
			} elseif (is_page()) {
				$trail .= get_the_title();
			} elseif (is_404()) {
				$trail .= "404";
			}
		} else {
			//bloginfo('name');
			$trail .= /*get_bloginfo('name')*/'<span class="fa fa-home fa-lg"></span>';
		}
		$trail .= '</div></div>';
		return $trail;
	}
?>