<?php

require_once('template/dependencies/index.php');

require_once('admin/ct_max_meta.php');

require_once('admin/handle-post.php');

require_once('admin/handle-metaboxes.php');

require_once('admin/lms-setting.php');

add_action('init', 'vq_apex_custom_posts');

add_action('init', 'vq_apex_custom_posts');

add_action('init', 'vq_apex_custom_taxonomies');

add_action('wp_ajax_processOrder', 'vq_lms_process_order');

add_action('wp_ajax_nopriv_processOrder', 'vq_lms_process_order');

add_filter('wp_nav_menu_items', 'vq_add_lms_navigation', 10, 2);

add_filter('query_vars', 'vq_query_vars_filter');

add_filter('single_template', 'vq_render_order_single_page', 10, 2);

add_shortcode('vq_short_banner', 'vq_render_short_banner');

add_filter('query_vars', 'vq_query_vars_filter');

add_shortcode('vq_course_banner', 'vq_render_course_banner');

add_shortcode('vq_lms_inquiry_form', 'vq_render_inquiry_form');

add_action( 'vq_course_promo_add_form_fields', 'add_course_promo', 10, 2 );
add_action( 'vq_course_promo_edit_form_fields', 'edit_course_promo', 10, 2 );
add_action( 'created_vq_course_promo', 'save_course_promo', 10, 2 );
add_action( 'edited_vq_course_promo', 'save_course_promo', 10, 2 );

add_action('wp_ajax_nopriv_check_promo', 'vq_check_promo', 10, 2);
add_action('wp_ajax_check_promo', 'vq_check_promo', 10, 2);

function set_html_content_type(){
    return 'text/html';
}

function vq_check_promo() {
    $code = $_POST['data'];
    $val = -1;

    $terms = get_terms(array(
        'taxonomy'  =>  'vq_course_promo',
	    'hide_empty' => false,
    ));
    foreach($terms as $term) {
        if($code === $term->name) {
            $val = get_term_meta($term->term_id, 'vq_course_promo_value', true);
        }
    }

    echo $val;

    wp_die();
}


function add_course_promo() {
	?>
	<div class="form-field term-group">
		<label for="vq_course_taxonomy-image-id">Value</label>
		<input type="number" name="vq_course_promo_value" value="0" min="0" max="100" required> %
	</div>
	<?php
}

function edit_course_promo($term) {
    $value = get_term_meta($term->term_id, 'vq_course_promo_value', true);
	?>
    <tr class="form-field term-group-wrap">
        <th scope="row">
            <label for="vq_course_taxonomy-id">Value</label>
        </th>
        <td>
            <input type="number" name="vq_course_promo_value" value="<?php echo $value; ?>"> %
        </td>
    </tr>
	<?php
}

function save_course_promo($term_id) {
	if(isset($_POST['vq_course_promo_value'])) {
	    $val = $_POST['vq_course_promo_value'];
	    update_term_meta($term_id, 'vq_course_promo_value', $val);
    }
}

function vq_lms_process_order()
{
    if (!isset($_POST['data'])) {
        echo "Unable to process your request";
        die;
    }

    $data = json_decode(stripslashes($_POST['data']), true);

	if ($data['terms'] != 'on') {
		echo "Terms & Conditions not accepted.";
		die;
	}

    $code = "";
    if(isset($data['pcode'])) {
        $code = $data['pcode'];
    }

    if (count($data['data']) === 0) {
        echo "Unable to process your request";
        die;
    }

    $options = get_option('vq_lms_settings_options');
    //$to = get_option('vq_lms_payment_notify_email');

    $itemsXML = "";
    $totalCost = 0;
    $postContent = "<h2>Items:</h2>";

	$oid = $data['id'];
	$data = $data['data'];



	if($code != ""){

		$val = -1;

		$terms = get_terms(array(
			'taxonomy'  =>  'vq_course_promo',
			'hide_empty' => false,
		));

		foreach($terms as $term) {
			if($code === $term->name) {
				$val = get_term_meta($term->term_id, 'vq_course_promo_value', true);
			}
		}

	}


    foreach ($data as $user) {
        $coursesId = array_column($user['courses'], "id");

        foreach ($coursesId as $cid) {
            $course = get_post($cid);

            $item = $course->post_title . " (" . $user['fname'] . ")";
            $cost = get_post_meta($course->ID, "course_fee", true);
            if (!$cost) {
                $cost = $options['vq_lms_settings_field_general_price'];
            }
            if (!$cost) {
                echo "Unable to process your request";
                die;
            }
            if($val != -1 ) {
	            $cost = ceil(((100 - $val)/100) * $cost);
            }
            $totalCost += floatval($cost);
            $itemsXML .= "<Items><itemname>".$item."</itemname><quantity>1</quantity><amount>".number_format((float)$cost,
                    2, '.', '')."</amount></Items>";

            $postContent .= $item." 1 ".number_format((float)$cost,2, '.', '')."<br />";
            $postContent .= $user['email']."<br />";
            $postContent .= $user['phone']."<br /><hr />";

        }

    }

//            $to .= ', '.$user['email'];
//            $subject = "Checkout Confirmation";
//            $body = '';
//            $body .= $postContent;
//
//            add_filter('wp_mail_content_type', 'set_html_content_type');
//            wp_mail($to, $subject, $body);
//            remove_filter('wp_mail_content_type', 'set_html_content_type');
//            wp_mail($to, "APEX Checkout", $postContent);

    if($oid > 0) {
    	$post = array(
    		'ID'            =>  $oid,
		    'post_content'  =>  $postContent,
		    "post_title" => date("Y-m-d h:i:sa"),
		    "post_type" => "vq_lms_orders",
		    "post_status" => "publish"
	    );

    	wp_update_post($post);

    } else {
	    $oid = wp_insert_post(array(
		    "post_content" => $postContent,
		    "post_title" => date("Y-m-d h:i:sa"),
		    "post_type" => "vq_lms_orders",
		    "post_status" => "publish"
	    ));


    }


    update_post_meta($oid, 'order_data', $data);

    $learner = $data[0];
    $name = explode(' ', $learner['fname']);


    $_mid = get_option("vq_lms_payment_merchant_id");
    $_requestid = substr(uniqid(), 0, 13);
    $_noturl = site_url("lms-notify?order_id={$oid}");//////site_url("https://requestb.in/1cz13lh1"); // url where response is posted
    $_resurl = site_url("thank-you-download"); //url of merchant landing page
    $_cancelurl = site_url("lms-cancel"); //url of merchant landing page
    $_fname = $name[0]; // kindly set this to first name of the cutomer
    $_lname = $name[1]; // kindly set this to last name of the cutomer
    $_addr1 = "online"; // kindly set this to address1 of the cutomer
    $_sec3d = "try3d"; //
    $_email = $learner["email"]; // kindly set this to email of the cutomer
    $_phone = $learner["phone"]; // kindly set this to phone number of the cutomer
    $_clientip = $_SERVER['REMOTE_ADDR'];
    $_amount = number_format((float)$totalCost, 2, '.', ''); // kindly set this to the total amount of the

	update_post_meta($oid, 'man_request_id', $_requestid);
	update_post_meta($oid, 'total_amount', $_amount);
	update_post_meta($oid, 'payment_status', 'PENDING');

    // transaction. Set the amount to 2 decimal
    // point before generating signature.
    $_currency = $options['vq_lms_settings_field_currency_symbol'];

    $forSign = $_mid . $_requestid . $_noturl . $_resurl . $_fname . $_lname . $_addr1 . $_email . $_phone .
        $_clientip . $_amount . $_currency . $_sec3d;
    $cert = get_option("vq_lms_payment_merchant_key");
    $_sign = hash("sha512", $forSign . $cert);

    $strxml = "";
    $strxml = $strxml . "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
    $strxml = $strxml . "<Request>";
    $strxml = $strxml . "<orders>";
    $strxml = $strxml . "<items>";
//    $strxml = $strxml . "<Items>";
    $strxml = $strxml . $itemsXML;//"<itemname>item 1</itemname><quantity>1</quantity><amount>10.00</amount>"; // pls
    // change this value to the preferred item to be seen by customer. (eg. Room Detail (itemname - Beach Villa, 1 Room, 2 Adults       quantity - 0       amount - 10)) NOTE : total amount of item/s should be equal to the amount passed in amount xml node below.
//    $strxml = $strxml . "</Items>";
    $strxml = $strxml . "</items>";
    $strxml = $strxml . "</orders>";
    $strxml = $strxml . "<mid>" . $_mid . "</mid>";
    $strxml = $strxml . "<request_id>" . $_requestid . "</request_id>";
//    $strxml = $strxml . "<ip_address>" . $_ipaddress . "</ip_address>";
    $strxml = $strxml . "<notification_url>" . $_noturl . "</notification_url>";
    $strxml = $strxml . "<response_url>" . $_resurl . "</response_url>";
    $strxml = $strxml . "<cancel_url>" . $_cancelurl . "</cancel_url>";
    $strxml = $strxml . "<mtac_url>https://www.google.com</mtac_url>"; // pls set this to the url where your terms and conditions are hosted
    $strxml = $strxml . "<descriptor_note>''</descriptor_note>"; // pls set this to the descriptor of the merchant ""
    $strxml = $strxml . "<fname>" . $_fname . "</fname>";
    $strxml = $strxml . "<lname>" . $_lname . "</lname>";
//    $strxml = $strxml . "<mname>" . $_mname . "</mname>";
    $strxml = $strxml . "<address1>" . $_addr1 . "</address1>";
//    $strxml = $strxml . "<address2>" . $_addr2 . "</address2>";
//    $strxml = $strxml . "<city>" . $_city . "</city>";
//    $strxml = $strxml . "<state>" . $_state . "</state>";
//    $strxml = $strxml . "<country>" . $_country . "</country>";
//    $strxml = $strxml . "<zip>" . $_zip . "</zip>";
    $strxml = $strxml . "<secure3d>" . $_sec3d . "</secure3d>";
    $strxml = $strxml . "<trxtype>sale</trxtype>";
    $strxml = $strxml . "<email>" . $_email . "</email>";
    $strxml = $strxml . "<phone>" . $_phone . "</phone>";
//    $strxml = $strxml . "<mobile>" . $_mobile . "</mobile>";
    $strxml = $strxml . "<client_ip>" . $_clientip . "</client_ip>";
    $strxml = $strxml . "<amount>" . $_amount . "</amount>";
    $strxml = $strxml . "<currency>" . $_currency . "</currency>";
    $strxml = $strxml . "<mlogo_url></mlogo_url>";// pls set this to the url where your logo is hosted
    $strxml = $strxml . "<pmethod></pmethod>";
    $strxml = $strxml . "<signature>" . $_sign . "</signature>";
    $strxml = $strxml . "</Request>";



    echo base64_encode($strxml);

    die;
}

function vq_apex_custom_posts()
{

    /*  Course Post Type    */
    $labels = array(
        'name' => __('LMS Courses'),
        'singular_name' => __('LMS Course'),
        'menu_name' => __('LMS Courses'),
        'name_admin_bar' => __('LMS Course'),
        'add_new' => __('Add New', 'course'),
        'add_new_item' => __('Add New LMS Course'),
        'new_item' => __('New LMS Course'),
        'edit_item' => __('Edit LMS Course'),
        'view_item' => __('View LMS Course'),
        'all_items' => __('All LMS Courses'),
        'search_items' => __('Search LMS Courses'),
        'parent_item_colon' => __('Parent LMS Courses:'),
        'not_found' => __('No lms courses found.'),
        'not_found_in_trash' => __('No lms courses found in Trash.')
    );

    $args = array(
        'labels' => $labels,
        'description' => __('Description.'),
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'lms-course'),
        'capability_type' => 'post',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'supports' => array('title', 'editor', 'thumbnail')
    );

    register_post_type('vq_course', $args);


    /*  Download Request Post Type  */
    $labels = array(
        'name' => __('Download Requests'),
        'singular_name' => __('Download Request'),
        'menu_name' => __('Download Requests'),
        'name_admin_bar' => __('Download Requests'),
        'add_new' => __('Add New', 'download_request'),
        'add_new_item' => __('Add New Download Request'),
        'new_item' => __('New Download Request'),
        'edit_item' => __('Edit Download Request'),
        'view_item' => __('View Download Request'),
        'all_items' => __('Download Requests'),
        'search_items' => __('Search Download Requests'),
        'parent_item_colon' => __('Parent Download Requests:'),
        'not_found' => __('No Download Request found.'),
        'not_found_in_trash' => __('No Download Request found in Trash.')
    );

    $args = array(
        'labels' => $labels,
        'description' => __('Description.'),
        'public' => false,
        'publicly_queryable' => false,
        'show_ui' => true,
        'show_in_menu' => "edit.php?post_type=vq_course",
        'query_var' => true,
        'rewrite' => false,
        'capability_type' => 'post',
        'has_archive' => false,
        'hierarchical' => false,
        'supports' => array('title', 'editor', 'thumbnail')
    );

    register_post_type('vq_lms_drequest', $args);

    /*  Pricing Requests Post Type  */

    $labels = array(
        'name' => __('Pricing Requests'),
        'singular_name' => __('Pricing Request'),
        'menu_name' => __('Pricing Requests'),
        'name_admin_bar' => __('Pricing Requests'),
        'add_new' => __('Add New', 'download_request'),
        'add_new_item' => __('Add New Pricing Request'),
        'new_item' => __('New Pricing Request'),
        'edit_item' => __('Edit Pricing Request'),
        'view_item' => __('View Pricing Request'),
        'all_items' => __('Pricing Requests'),
        'search_items' => __('Search Pricing Requests'),
        'parent_item_colon' => __('Parent Pricing Requests:'),
        'not_found' => __('No Pricing Request found.'),
        'not_found_in_trash' => __('No Pricing Request found in Trash.')
    );

    $args = array(
        'labels' => $labels,
        'description' => __('Description.'),
        'public' => false,
        'publicly_queryable' => false,
        'show_ui' => true,
        'show_in_menu' => "edit.php?post_type=vq_course",
        'query_var' => true,
        'rewrite' => false,
        'capability_type' => 'post',
        'has_archive' => false,
        'hierarchical' => false,
        'supports' => array('title', 'editor', 'thumbnail')
    );

    register_post_type('vq_lms_prequest', $args);

    /*  Pricing Requests Post Type  */

    $labels = array(
        'name' => __('Orders'),
        'singular_name' => __('Order'),
        'menu_name' => __('Orders'),
        'name_admin_bar' => __('Orders'),
        'add_new' => __('Add New', 'download_request'),
        'add_new_item' => __('Add New Order'),
        'new_item' => __('New Order'),
        'edit_item' => __('Edit Order'),
        'view_item' => __('View Order'),
        'all_items' => __('Orders'),
        'search_items' => __('Search Orders'),
        'parent_item_colon' => __('Parent Orders:'),
        'not_found' => __('No Orders found.'),
        'not_found_in_trash' => __('No Orders found in Trash.')
    );

    $args = array(
        'labels' => $labels,
        'description' => __('LMS Orders.'),
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => "edit.php?post_type=vq_course",
        'query_var' => true,
        'rewrite' => array('slug'   =>  'order'),
        'capability_type' => 'post',
        'has_archive' => false,
        'hierarchical' => false,
        'supports' => array('title', 'editor')
    );

    register_post_type('vq_lms_orders', $args);
}

function vq_apex_custom_taxonomies() {

    register_taxonomy(
        'vq_course_taxonomy',
        'vq_course',
        array(
            'label' =>  'LMS Course Category',
            'show_ui' => true,
            'show_tagcloud' => false,
            'hierarchical' => true,
            'rewrite' => array('slug' => 'e-learning', 'with_front' => false),
        )
    );

	$labels = array(
		'name' => 'Promo Code',
		'add_new_item' => 'Add New Promo Code',
		'new_item_name' => 'New Promo Code'
	);

	register_taxonomy(
		'vq_course_promo',
		'vq_course',
		array(
			'labels'     =>  $labels,
			'show_ui' => true,
			'show_tagcloud' => false,
			'description' => null,
			'hierarchical' => false,
		)
	);
}

function vq_add_lms_navigation($items, $args)
{
    $items .= '<li id="menu-item-786" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-786"><a href="' . site_url('lms') . '">E-Learning</a></li>';
    return $items;
}

function vq_query_vars_filter($vars)
{
    $vars[] = "course";
    return $vars;
}

function vq_render_short_banner($attr)
{

    $bgColor = isset($attr['bgclr']) ? $attr['bgclr'] : "#000";
    $btnBg = isset($attr['btnbg']) ? $attr['btnbg'] : "#00f";
    $txt = isset($attr['txt']) ? $attr['txt'] : "Heading";
    $txtClr = isset($attr['txtclr']) ? $attr['txtclr'] : "#fff";
    $btnClr = isset($attr['btnclr']) ? $attr['btnclr'] : "#fff";
    $btnLink = isset($attr['btnlink']) ? site_url($attr['btnlink']) : site_url("download-all");
    $btnTxt = isset($attr['btntxt']) ? $attr['btntxt'] : 'Click Here';


    $banner = file_get_contents(__DIR__ . '/admin/includes/short-banner.html');

    $banner = str_replace('[[TXT]]', $txt, $banner);

    $banner = str_replace('[[BTN_TXT]]', $btnTxt, $banner);
    $banner = str_replace('[[BANNER_BG]]', $bgColor, $banner);
    $banner = str_replace('[[BTN_LINK]]', $btnLink, $banner);
    $banner = str_replace('[[BTN_BG]]', $btnBg, $banner);
    $banner = str_replace('[[TXT_CLR]]', $txtClr, $banner);
    $banner = str_replace('[[BTN_CLR]]', $btnClr, $banner);

    return $banner;


}

function vq_render_course_banner($attr)
{
    if (!isset($attr['id'])) {
        return 'No Course Found';
    } else {
        $cid = $attr['id'];
    }

    $page = get_post($cid);

    $fee = get_post_meta($page->ID, 'course_fee', true);

    if (empty($fee) || $fee <= 0) {
        $settings = get_option('vq_lms_settings_options');
        $fee = $settings['vq_lms_settings_field_intro_price'];
    }

    $banner = file_get_contents(__DIR__ . '/admin/includes/large-banner.html');

    $banner = str_replace('[[BANNER_HEADING]]', $page->post_title, $banner);

    $banner = str_replace('[[BANNER_DESCRIPTION]]', $page->post_content, $banner);

    $banner = str_replace('[[BG_IMG]]', get_the_post_thumbnail_url($cid), $banner);

    $banner = str_replace('[[REDIRECT_URL]]', get_permalink($page->ID), $banner);

    $banner = str_replace('[[FEE]]', $fee, $banner);

    return $banner;
}

function vq_render_inquiry_form() {

	$file = file_get_contents(__DIR__ . '/admin/includes/inquiry-now.html');

	return $file;
}

function vq_render_order_single_page($single_template) {
	global $post;
	if($post->post_type == 'vq_lms_orders') {
		$single_template = dirname(__FILE__) . '/template/learner-detail.php';
	}
	return $single_template;
}