(function ($) {
    var lmsLearners = $("#lms-learners");
    var courseSummeryHolder = $(".lms-summery-course");
    var lmsCheckoutForm = $("#lmsCheckoutForm");

    var learnerFormTemplate = $("#learnerTemplate").html();
    var singleCourseTemplate = $("#singleCourseTemplate").html();
    var lmsSummeryCourse = $("#lmsSummeryCourse").html();
    var lmsSummerySingleLearner = $("#lmsSummerySingleLearner").html();

    var addLearnerBtn = $("#lms-add-learner");
    var learners = [];

    function renderLearnersPage() {
        renderLearnersForm();
        renderOrderSummery();
    }

    function renderOrderSummery() {
        var selectedCourses = [];
        var uniqueId = [];
        var courseLearner = [];
        var totalCost = 0;

        learners.forEach(function (learner) {
            selectedCourses = selectedCourses.concat(learner.courses);
            learner.courses.forEach(function (course) {
                if (!courseLearner[course.id]) {
                    courseLearner[course.id] = [];
                }
                courseLearner[course.id].push(learner);
            })
        });
        selectedCourses = selectedCourses.filter(function (course) {
            if (uniqueId.indexOf(course.id) === -1) {
                uniqueId.push(course.id);
                return course;
            }
        });


        courseSummeryHolder.html("");
        selectedCourses.forEach(function (course) {
            var lmsSummeryCourseElem = $(lmsSummeryCourse);

            lmsSummeryCourseElem.find(".courseName").html(course.name);
            courseSummeryHolder.append(lmsSummeryCourseElem);

            courseLearner[course.id].forEach(function (learner, index) {
                var lmsSummerySingleElem = $(lmsSummerySingleLearner);
                lmsSummerySingleElem.find(".index").html(index + 1);
                lmsSummerySingleElem.find(".name").html(learner.name);
                lmsSummerySingleElem.find(".email").html(learner.email);
                lmsSummerySingleElem.find(".phone").html(learner.phone);
                lmsSummerySingleElem.find(".price").html(course.cost + " " + lmsSettings.vq_lms_settings_field_currency_symbol);
                totalCost += parseFloat(course.cost);
                courseSummeryHolder.append(lmsSummerySingleElem);
            });
        });

        $(".lms-total").html(totalCost + " " + lmsSettings.vq_lms_settings_field_currency_symbol);
        $(".lms-grand-total").html(totalCost + " " + lmsSettings.vq_lms_settings_field_currency_symbol);
    }

    function renderLearnersForm() {
        lmsLearners.html("");
        learners.forEach(function (item, index) {
            var learnerFormElement = $(learnerFormTemplate);
            learnerFormElement.find(".lmsIndex").html(index + 1);
            learnerFormElement.find("input[name='name']").val(item.name);
            learnerFormElement.find("input[name='email']").val(item.email);
            learnerFormElement.find("input[name='confirmEmail']").val(item.confirmEmail);
            learnerFormElement.find("input[name='phone']").val(item.phone);


            if (index == 0) {
                learnerFormElement.find(".lms-learner-remove span").html("");
            } else {
                learnerFormElement.find(".lms-learner-remove span").click(removeLearner.bind(index));
            }
            learnerFormElement.find(".lms-courses-select-btn").click(showAddMoreCourses.bind(item));
            learnerFormElement.find("input").keyup(updateLearnerInfo.bind(item));
            learnerFormElement.find("input").change(updateLearnerInfo.bind(item));

            var couseHolder = learnerFormElement.find(".lms-all-course-holder");
            couseHolder.html("");
            if (item.courses.length === 0) {
                couseHolder.html('<div class="lms-single-course-holder"> \
                    <span class="name">No course selected.</span> \
                <div class="clear"></div> \
                    </div>')
            }
            item.courses.forEach(function (course) {
                var singleCourseElement = $(singleCourseTemplate);
                course.cost = (course.cost) ? course.cost : lmsSettings.vq_lms_settings_field_general_price;

                singleCourseElement.find(".name").html(course.name)
                singleCourseElement.find(".price").html(course.cost + " " + lmsSettings.vq_lms_settings_field_currency_symbol)
                singleCourseElement.find(".remove").click(removeCourse.bind(item, course.id));
                couseHolder.append(singleCourseElement);
            });


            item.element = learnerFormElement;
            lmsLearners.append(learnerFormElement);
        })
    }

    function removeCourse(courseId) {
        this.courses = this.courses.filter(function (course) {
            return course.id != courseId;
        });
        renderLearnersPage();
    }

    function showAddMoreCourses(e) {
        e.preventDefault();
        var select = this.element.find(".lms-courses-select");
        this.element.find(".lms-courses-select-btn").hide();
        select.show();
        select.find("select").chosen({
            no_results_text: "Oops, no courses found!"
        }).change(onCourseSelected.bind(this));
    }

    function onCourseSelected(e) {
        var selectedCourse = courses.filter(function (item) {
            return item.id == e.target.value
        });

        if (selectedCourse.length > 0) {
            if (this.courses.indexOf(selectedCourse[0]) === -1)
                this.courses.push(selectedCourse[0]);
        }

        this.element.find(".lms-courses-select").hide();
        this.element.find(".lms-courses-select-btn").show();

        renderLearnersPage();
    }

    function updateLearnerInfo(e) {
        var input = $(e.target);
        this[input.attr("name")] = input.val();
        renderOrderSummery();
    }

    function removeLearner() {
        learners.splice(this, 1);
        renderLearnersPage();
    }

    function addEmptyLearner() {
        var lerner = {
            name: "",
            email: "",
            confirmEmail: "",
            phone: "",
            courses: []
        };

        learners.push(lerner);
    }

    function initEvents() {
        addLearnerBtn.click(function (e) {
            addEmptyLearner();
            renderLearnersPage();
        });
    }

    if (lmsLearners.length) {
        initEvents();
        addEmptyLearner();
        renderLearnersPage();
    }


    lmsCheckoutForm.submit(function (e) {
        var learnersWithNoCourse = learners.filter(function (learner) {
            return learner.courses.length === 0;
        });

        if (learnersWithNoCourse.length > 0) {
            alert("Please select courses with all learners.");
            e.preventDefault();
        }
    });

})(jQuery);