<?php

require_once('template/dependencies/index.php');

require_once('admin/ct_max_meta.php');

require_once('admin/handle-post.php');

require_once('admin/handle-metaboxes.php');

require_once('admin/lms-setting.php');

add_action('init', 'vq_apex_custom_posts');

add_action('init', 'vq_apex_custom_taxonomies');

add_filter('wp_nav_menu_items', 'vq_add_lms_navigation', 10, 2);

add_filter( 'query_vars', 'vq_query_vars_filter' );

add_action( 'admin_menu', 'vq_add_plugin_setting_page' );

add_shortcode('vq_short_banner', 'vq_render_short_banner');

add_filter( 'query_vars', 'vq_query_vars_filter' );

add_shortcode('vq_short_banner', 'vq_render_short_banner');

add_shortcode('vq_large_banner', 'vq_render_large_banner');

function vq_apex_custom_posts() {

	/*  Course Post Type    */
	$labels = array(
		'name'               => __( 'LMS Courses'),
		'singular_name'      => __( 'LMS Course'),
		'menu_name'          => __( 'LMS Courses'),
		'name_admin_bar'     => __( 'LMS Course'),
		'add_new'            => __( 'Add New', 'course'),
		'add_new_item'       => __( 'Add New LMS Course'),
		'new_item'           => __( 'New LMS Course'),
		'edit_item'          => __( 'Edit LMS Course'),
		'view_item'          => __( 'View LMS Course'),
		'all_items'          => __( 'All LMS Courses'),
		'search_items'       => __( 'Search LMS Courses'),
		'parent_item_colon'  => __( 'Parent LMS Courses:'),
		'not_found'          => __( 'No lms courses found.'),
		'not_found_in_trash' => __( 'No lms courses found in Trash.')
	);

	$args = array(
		'labels'             => $labels,
		'description'        => __( 'Description.'),
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => array( 'slug' => 'vq_course' ),
		'capability_type'    => 'post',
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'supports'           => array( 'title', 'editor', 'thumbnail')
	);

	register_post_type( 'vq_course', $args );


	/*  Download Request Post Type  */
	$labels = array(
		'name'               => __( 'Download Requests'),
		'singular_name'      => __( 'Download Request'),
		'menu_name'          => __( 'Download Requests'),
		'name_admin_bar'     => __( 'Download Requests'),
		'add_new'            => __( 'Add New', 'download_request'),
		'add_new_item'       => __( 'Add New Download Request'),
		'new_item'           => __( 'New Download Request'),
		'edit_item'          => __( 'Edit Download Request'),
		'view_item'          => __( 'View Download Request'),
		'all_items'          => __( 'Download Requests'),
		'search_items'       => __( 'Search Download Requests'),
		'parent_item_colon'  => __( 'Parent Download Requests:'),
		'not_found'          => __( 'No Download Request found.'),
		'not_found_in_trash' => __( 'No Download Request found in Trash.')
	);

	$args = array(
		'labels'             => $labels,
		'description'        => __( 'Description.'),
		'public'             => false,
		'publicly_queryable' => false,
		'show_ui'            => true,
		'show_in_menu'       => "edit.php?post_type=vq_course",
		'query_var'          => true,
		'rewrite'            => false,
		'capability_type'    => 'post',
		'has_archive'        => false,
		'hierarchical'       => false,
		'supports'           => array( 'title', 'editor', 'thumbnail')
	);

	register_post_type( 'vq_lms_drequest', $args );
}

function vq_apex_custom_taxonomies() {
	$labels = array(
		'name'          =>  'LMS Category',
		'add_new_item'  =>  'Add New LMS Category',
		'new_item_name' =>  'New LMS Category'
	);

	register_taxonomy(
		'vq_course_taxonomy',
		'vq_course',
		array(
			$labels,
			'show_ui'       =>  true,
			'show_tagcloud' => false,
			'hierarchical' => true,
			'rewrite'             => array( 'slug' => 'e-learning', 'with_front' => false ),
		)
	);
}

function vq_add_lms_navigation($items, $args) {
	$items .= '<li id="menu-item-786" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-786"><a href="'.site_url('lms').'">E-Learning</a></li>';
	return $items;
}

function vq_query_vars_filter( $vars ){
	$vars[] = "course";
	return $vars;
}

function vq_render_short_banner($attr) {

	$bgColor = isset($attr['bgclr']) ? $attr['bgclr'] : "#000";
	$btnBg = isset($attr['btnbg']) ? $attr['btnbg'] : "#00f";
	$txt = isset($attr['txt']) ? $attr['txt'] : "Heading";
	$txtClr = isset($attr['txtclr']) ? $attr['txtclr'] : "#fff";
	$btnClr = isset($attr['btnclr']) ? $attr['btnclr'] : "#fff";
	$btnLink = isset($attr['btnlink']) ? $attr['btnlink'] : 'https://google.com';
	$btnTxt = isset($attr['btntxt']) ? $attr['btntxt'] : 'Click Here';


	$banner = file_get_contents(__DIR__ . '/admin/includes/short-banner.html');

	$banner = str_replace('[[TXT]]', $txt, $banner);

	$banner = str_replace('[[BTN_TXT]]', $btnTxt, $banner);
	$banner = str_replace('[[BANNER_BG]]', $bgColor, $banner);
	$banner = str_replace('[[BTN_LINK]]', $btnLink, $banner);
	$banner = str_replace('[[BTN_BG]]', $btnBg, $banner);
	$banner = str_replace('[[TXT_CLR]]', $txtClr, $banner);
	$banner = str_replace('[[BTN_CLR]]', $btnClr, $banner);

	echo $banner;


}

function vq_render_large_banner($attr) {

	$pgslg = isset($attr['pgslg']) ? $attr['pgslg'] : "none";

	$page = get_page_by_path($pgslg);

	$banner = file_get_contents(__DIR__ . '/admin/includes/large-banner.html');

	$banner = str_replace('[[BANNER_HEADING]]', $page->post_title, $banner);

	$banner = str_replace('[[BANNER_DESCRIPTION]]', $page->post_content, $banner);

	$banner = str_replace('[[BG_IMG]]', get_the_post_thumbnail_url(get_page_by_path($pgslg)), $banner);

	echo $banner;

}
