<?php



add_action( 'admin_menu', 'vq_lms_settings_page' );

add_action( 'admin_init', 'vq_lms_settings_init' );


function vq_lms_settings_init() {
	register_setting( 'vq_lms_settings', 'vq_lms_settings_options' );

	add_settings_section(
		'vq_lms_settings_section_developers',
		'General Settings',
		'vq_lms_settings_section_developers_cb',
		'vq_lms_settings'
	);

	add_settings_field(
		'vq_lms_settings_field_general_price',
		'Default Course Price',
		'vq_lms_settings_field_price_cb',
		'vq_lms_settings',
		'vq_lms_settings_section_developers',
		[
			'label_for' => 'vq_lms_settings_field_general_price',
			'class' => 'vq_lms_settings_row',
			'vq_lms_settings_custom_data' => 'custom',
		]
	);

	add_settings_field(
		'vq_lms_settings_field_currency_name',
		'Currency Name',
		'vq_lms_settings_field_currency_name_cb',
		'vq_lms_settings',
		'vq_lms_settings_section_developers',
		[
			'label_for' => 'vq_lms_settings_field_currency_name',
			'class' => 'vq_lms_settings_row',
			'vq_lms_settings_custom_data' => 'custom',
		]
	);

	add_settings_field(
		'vq_lms_settings_field_currency_symbol',
		'Currency Symbol',
		'vq_lms_settings_field_currency_symbol_cb',
		'vq_lms_settings',
		'vq_lms_settings_section_developers',
		[
			'label_for' => 'vq_lms_settings_field_currency_symbol',
			'class' => 'vq_lms_settings_row',
			'vq_lms_settings_custom_data' => 'custom',
		]
	);

	add_settings_field(
		'vq_lms_settings_field_video',
		'Video',
		'vq_lms_settings_field_video_cb',
		'vq_lms_settings',
		'vq_lms_settings_section_developers',
		[
			'label_for' => 'vq_lms_settings_field_video',
			'class' => 'vq_lms_settings_row',
			'vq_lms_settings_custom_data' => 'custom',
		]
	);
}

function vq_lms_settings_section_developers_cb( $args ) {

}

function vq_lms_settings_field_price_cb( $args ) {
	$options = get_option( 'vq_lms_settings_options' );

	?>
	<input type="text"
	       name="vq_lms_settings_options[<?php echo esc_attr( $args['label_for'] ); ?>]"
	       value="<?php echo  $options[$args['label_for']]; ?>"
	>
	<p class="description">
		<?php esc_html_e( 'Your entered price will be listed as default price for all courses unless specified for each.', 'vq_lms_settings' ); ?>
	</p>
	<?php
}

function vq_lms_settings_field_currency_name_cb($args) {
	$options = get_option( 'vq_lms_settings_options' );

	?>
	<input type="text"
	       name="vq_lms_settings_options[<?php echo esc_attr( $args['label_for'] ); ?>]"
	       value="<?php echo  $options[$args['label_for']]; ?>"
	>
	<p class="description">
		<?php esc_html_e( 'Your entered currency will be used for whole LMS system listing.', 'vq_lms_settings' ); ?>
	</p>
	<?php
}

function vq_lms_settings_field_currency_symbol_cb($args) {
	$options = get_option( 'vq_lms_settings_options' );

	?>
	<input type="text"
	       name="vq_lms_settings_options[<?php echo esc_attr( $args['label_for'] ); ?>]"
	       value="<?php echo  $options[$args['label_for']]; ?>"
	>
	<p class="description">
		<?php esc_html_e( 'Enter Currency Symbol.', 'vq_lms_settings' ); ?>
	</p>
	<?php
}

function vq_lms_settings_field_video_cb($args) {

    wp_enqueue_media();

	$options = get_option( 'vq_lms_settings_options' );

	if($options[$args['label_for']]) {
	    ?>
        <div style="width: 200px;" id="video_holder">
            <video id="vid" src="<?php echo $options[$args['label_for']];  ?>">
            </video>
        </div>
        <?php
    }

	?>

    <input type="button"
           id="vq_lms_video"
           class="button"
           value="Upload Video">
    <input type="button"
           id="vq_lms_remove_video"
           class="button"
           value="Remove Video">

    <input type="hidden"
           id="vq_lms_video_hidden"
           name="vq_lms_settings_options[<?php echo esc_attr( $args['label_for'] ); ?>]"
           value="<?php echo  $options[$args['label_for']]; ?>">

    <p class="description">
		<?php esc_html_e( 'video attachment to show.', 'vq_lms_settings' ); ?>
    </p>

    <script>
        var mediaUploader;
        jQuery("#vq_lms_remove_video").on('click', function() {
            jQuery("#vq_lms_video_hidden").val('');
            jQuery("#vid").attr('src', '');
        });
        jQuery('#vq_lms_video').on('click', function ( e ) {
            e.preventDefault();
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }
            mediaUploader = wp.media.frames.file_frame = wp.media({
                title: 'Select Video',
                button: {
                    text: 'Choose Video'
                },
                multiple: false
            });
            mediaUploader.on('select', function () {
                attachment = mediaUploader.state().get('selection').first().toJSON();
                jQuery("#vq_lms_video_hidden").val(attachment.url);
                jQuery("#vid").attr('src', attachment.url);
            });
            mediaUploader.open();
        });
    </script>

	<?php
}

function vq_lms_settings_page() {

	add_submenu_page('edit.php?post_type=vq_course',
		'Test Page',
		'Settings',
		'manage_options',
		'vq_lms_settings',
		'vq_lms_settings_page_html'
	);
}

function vq_lms_settings_page_html() {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}

	if ( isset( $_GET['settings-updated'] ) ) {
		add_settings_error(
			'vq_lms_settings_messages',
			'vq_lms_settings_message',
			'Settings Saved',
			'updated'
		);
	}

	settings_errors( 'vq_lms_settings_messages' );
	?>
	<div class="wrap">
		<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
		<form action="options.php" method="post">
			<?php
			settings_fields( 'vq_lms_settings' );
			do_settings_sections( 'vq_lms_settings' );
			submit_button( 'Save Settings' );
			?>
		</form>
	</div>
	<?php
}