<?php

add_action('add_meta_boxes', 'vq_add_custom_meta_boxes', 10, 2);

function vq_render_short_banner_shortcode_metabox() {
	echo '[vq_short_banner bgClr="" btnBg="" txt="" txtClr="" btnClr="" btnLink="" btnTxt=""]';
}

function vq_render_course_attachment_metabox() {
	wp_enqueue_media();

	$file = file_get_contents(__DIR__ . '/includes/attachmentAndPrice.html');

	$attachment_id = get_post_meta(get_the_ID(), 'course_attachment_id', true);
	$attachment_title = get_post_meta(get_the_ID(), 'course_attachment_title', true);
	$courseFee = get_post_meta(get_the_ID(), 'course_fee', true);

	if($attachment_id > 0) {
		$file = str_replace('[[ATTACHMENT]]', $attachment_title, $file);
		$file = str_replace('[[ATTACHMENT_ID]]', $attachment_id, $file);
	} else {
		$file = str_replace('[[ATTACHMENT]]', 'NONE', $file);
		$file = str_replace('[[ATTACHMENT_ID]]', -1, $file);
	}
	if($courseFee > 0) {
		$file = str_replace('[[PRICE]]', $courseFee, $file);
	} else {
		$file = str_replace('[[PRICE]]', '', $file);
	}

	echo $file;
}

function vq_add_custom_meta_boxes() {

	add_meta_box(
		'vq_short_banner_shortcode_metabox',
		'Short Banner Shortcode',
		'vq_render_short_banner_shortcode_metabox',
		'vq_course',
		'side',
		'high'
	);

	add_meta_box(
		'vq_course_attachment_metabox',
		'Attachment',
		'vq_render_course_attachment_metabox',
		'vq_course',
		'advanced',
		'high'
	);

}

