<?php
get_header();

$page = get_page_by_path('lms');
$course_categories = get_terms( array(
	'taxonomy' => 'vq_course_taxonomy',
	'hide_empty' => false,
));
//echo "<pre>";
//print_r($course_categories);

//exit;

?>
    <div class="bootstrap-iso">
        <div class="e-learning-banner" style="background-image: url(<?php echo get_the_post_thumbnail_url($page); ?>)">
            <div class="container">
                <div class="row">
                    <div class="e-learning-heading">
                        <h2><?php echo $page->post_title ?></h2>
                        <h3><?php echo $page->post_content ?></h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="learning-profile-bg">
            <div class="container">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="e-learning-heading">
                            <h4><?php echo $page->post_excerpt  ?></h4>
                        </div>
                    </div>
                    <?php foreach ($course_categories as $category){ ?>
                    <div class="col-sm-3">
                        <div class="learning-profile-box">
                            <div class="e-learning-course-1" style="background-image: url(<?php echo wp_get_attachment_url(get_term_meta($category->term_id, 'vq_course_taxonomy-image-id', true)) ?>)">
                                <div class="e-learning-heading">
                                    <h5><?php echo $category->name  ?></h5>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="e-learning-heading">
                                    <p><?php echo $category->description  ?></p>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="text-center">
                                    <a href="<?php echo get_permalink(get_page_by_path('lms-courses')) . $category->slug ?>" class="learn-button">Learn More</a>
                                </div>
                            </div>
                            <div class="clear"></div>
                        </div>
                    </div>
	                <?php } ?>
                </div>
            </div>
        </div>

	    <?php  do_shortcode('[vq_short_banner 
	        txtClr="#fff" 
	        btnClr="#fff" 
	        bgClr="#f89f18" 
	        btnBg="#2898c4" 
	        btnTxt="Download Full List Of Courses" 
	        txt="Not sure which course to take?"]'); ?>

        <?php do_shortcode('[vq_large_banner pgslg="banner"]') ?>

        <!--<div class="container">
            <div class="row">
                <div class="col-sm-12">
                    <div class="e-learning-heading">
                        <h4>Learning Management System</h4>
                    </div>
                </div>
            </div>
        </div>
        <div class="learning-manaegment-image">
            <div class="container">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="intro-box">
                            <div class="intro-heading">
                                <h2>Special <br>intro <br>price</h2>
                                <h3>$1.00</h3>
                                <h4>Per user / Per month</h4>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-8">
                        <div class="intro-heading">
                            <p>Had a two & a half day of information overload about cloud, virtualization, byod etc.
                                under the professional professional guidance of a well-experienced trainer named Raj &
                                it was all worth it. I was able to capture & internalize the required knowledge &
                                concepts & because of that I was able to pass the certification exam! Had a two & a half
                                day of information overload about cloud, virtualization, byod etc.</p>
                        </div>
                        <button type="submit" class="learn-button-1">Loern More</button>
                    </div>
                </div>
            </div>
        </div>-->
    </div>
<?php
get_footer();
?>