<?php

	/***************************************************************************************
		Function to get the client IP address
	***************************************************************************************/
	function get_client_ip() {
		$ipaddress = '';
		if (getenv('HTTP_CLIENT_IP'))
			$ipaddress = getenv('HTTP_CLIENT_IP');
		else if(getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else if(getenv('HTTP_X_FORWARDED'))
			$ipaddress = getenv('HTTP_X_FORWARDED');
		else if(getenv('HTTP_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_FORWARDED_FOR');
		else if(getenv('HTTP_FORWARDED'))
		   $ipaddress = getenv('HTTP_FORWARDED');
		else if(getenv('REMOTE_ADDR'))
			$ipaddress = getenv('REMOTE_ADDR');
		else
			$ipaddress = 'UNKNOWN';
		return $ipaddress;
	}

	/***************************************************************************************
		Register Widget Area
	***************************************************************************************/
	add_action( 'widgets_init', 'register_new_sidebar' );
	function register_new_sidebar() {
		
		/* Footer SEO Text */
		register_sidebar( array(
			'name' => __( 'Footer SEO Text', 'theme-slug' ),
			'id' => 'footer-seo-text',
			'description' => __( 'Widgets in this area will be shown in the footer.', 'theme-slug' ),
			'before_widget' => '<div id="%1$s" class="widget et_pb_widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widgettitle">',
			'after_title'   => '</h4>',
		) );
		
		/* Cart Sidebar */
		register_sidebar( array(
			'name' => __( 'Cart Sidebar', 'theme-slug' ),
			'id' => 'cart-sidebar',
			'description' => __( 'Widgets in this area will be shown in the cart page.', 'theme-slug' ),
			'before_widget' => '<div id="%1$s" class="widget et_pb_widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widgettitle">',
			'after_title'   => '</h4>',
		) );

		/* Blog Sidebar */
		register_sidebar( array(
			'name' => __( 'Blog Sidebar', 'theme-slug' ),
			'id' => 'blog-sidebar',
			'description' => __( 'Widgets in this area will be shown in the blog page.', 'theme-slug' ),
			'before_widget' => '<div id="%1$s" class="widget et_pb_widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widgettitle">',
			'after_title'   => '</h4>',
		) );
		
		/* iNugget Sidebar */
		register_sidebar( array(
			'name' => __( 'iNugget Sidebar', 'theme-slug' ),
			'id' => 'inugget-sidebar',
			'description' => __( 'Widgets in this area will be shown in the iNugget page.', 'theme-slug' ),
			'before_widget' => '<div id="%1$s" class="widget et_pb_widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widgettitle">',
			'after_title'   => '</h4>',
		) );
		
		/* Webinar Sidebar */
		register_sidebar( array(
			'name' => __( 'Webinar Sidebar', 'theme-slug' ),
			'id' => 'webinar-sidebar',
			'description' => __( 'Widgets in this area will be shown in the webinar page.', 'theme-slug' ),
			'before_widget' => '<div id="%1$s" class="widget et_pb_widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widgettitle">',
			'after_title'   => '</h4>',
		) );

		/* Forum Sidebar */
		register_sidebar( array(
			'name' => __( 'Forum Sidebar', 'theme-slug' ),
			'id' => 'forum-sidebar',
			'description' => __( 'Widgets in this area will be shown in the forum page.', 'theme-slug' ),
			'before_widget' => '<div id="%1$s" class="widget et_pb_widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widgettitle">',
			'after_title'   => '</h4>',
		) );
		
	}
	
	/***************************************************************************************
		ADD CLASS TO BODY
	***************************************************************************************/
	add_filter( 'body_class', 'body_class_names' );
	function body_class_names( $classes ) {

		/* Add full-width class to the WooCommerce Single Product */
		if( preg_match('/\/shop\/+/i', $_SERVER['REQUEST_URI']) AND is_single()){
			$classes[] = 'et_full_width_page';
		}
		
		return $classes;
	}
	
	
	/***************************************************************************************
		REMOVE WooCommerce RELATES PRODUCTS IN SINGLE TEMPLATE
	***************************************************************************************/
	function wc_remove_related_products( $args ) {
		return array();
	}
	add_filter('woocommerce_related_products_args','wc_remove_related_products', 10);

	
	include_once('function_extension.php');
	include_once('function_helper.php');
	
	/***************************************************************************************
		WP CF7 to Pipeline Extenstion
	***************************************************************************************/
	$pipeline_ip_filter = array("127.0.0.1", "125.212.50.126", "115.85.28.204");
	if (in_array(get_client_ip(), $pipeline_ip_filter) == FALSE) {
		include_once('function_cf7_to_pipelinedeals.php');
	}
	
	/***************************************************************************************
		Add Additional Column in the Dashboard Listing for All-Courses
	***************************************************************************************/
	add_filter('manage_edit-all-courses_columns', 'add_all_courses_columns');
	function add_all_courses_columns($gallery_columns) {
		$new_columns['cb'] = '<input type="checkbox" />';
		//$new_columns['id'] = __('ID');
		$new_columns['title'] = _x('Title', 'column name');
		$new_columns['author'] = __('Author');
		$new_columns['course_category'] = __('Categories');
		$new_columns['tags'] = __('Tags');
		$new_columns['date'] = _x('Date', 'column name');
	 
		return $new_columns;
	}
	
		// Add to admin_init function
		add_action('manage_all-courses_posts_custom_column', 'manage_all_courses_columns', 10, 2);
		function manage_all_courses_columns($column_name, $id) {
			global $wpdb;
			switch ($column_name) {
			case 'id':
				echo $id;
					break;
			case 'course_category':
				$course_category = array();
				$query_str = "SELECT post.ID, term.term_id as cat_id, term.name as cat_name, term.slug as slug
					FROM ap_posts AS post 
					LEFT JOIN ap_term_relationships AS relation ON post.ID=relation.object_id
					LEFT JOIN ap_term_taxonomy AS taxonomy ON relation.term_taxonomy_id=taxonomy.term_taxonomy_id
					LEFT JOIN ap_terms AS term ON taxonomy.term_id=term.term_id
					WHERE post.post_status='publish'
					AND post.ID={$id}";
				$total_rows	= $wpdb->get_results($query_str, OBJECT);
				foreach($total_rows as $val){
					$course_category[] = '<a href="/wp-admin/edit.php?course-category='. $val->slug .'&post_type=all-courses">'. $val->cat_name .'</a>';
				}
				echo implode(", ", $course_category);
				break;
			default:
				break;
			} // end switch
		}   

add_filter( 'clean_url','functionddd', 11, 1 );

 function functionddd ( $url ){
    if ( FALSE === strpos( $url, '.js' ) ){ // not our file
        return $url;
    }
    // Must be a ', not "!
    return "$url' defer='defer";
}

/*function optimize_jquery() {
if (!is_admin()) {
wp_deregister_script('jquery');
wp_deregister_script('jquery-migrate.min');
wp_deregister_script('comment-reply.min');
$protocol='http:';
if($_SERVER['HTTPS']=='on') {
$protocol='https:';
}
wp_register_script('jquery', $protocol.'//code.jquery.com/jquery-latest.js', false, '4.7.4', true);

wp_enqueue_script('jquery');
}
}
add_action('template_redirect', 'optimize_jquery');*/
	
	